/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;
import one.jfr.event.LiveObject;

public class jfr2flame {
    private static final String[] FRAME_SUFFIX = new String[]{"_[0]", "_[j]", "_[i]", "", "", "_[k]", "_[1]"};
    private final JfrReader jfr;
    private final Arguments args;

    public jfr2flame(JfrReader jfr, Arguments args) {
        this.jfr = jfr;
        this.args = args;
    }

    public void convert(FlameGraph fg) throws IOException {
        Class<LiveObject> eventClass = this.args.live ? LiveObject.class : (this.args.alloc ? AllocationSample.class : (this.args.lock ? ContendedLock.class : ExecutionSample.class));
        this.jfr.stopAtNewChunk = true;
        while (!this.jfr.eof()) {
            this.convertChunk(fg, eventClass);
        }
    }

    public void convertChunk(final FlameGraph fg, Class<? extends Event> eventClass) throws IOException {
        Event event;
        long endTicks;
        EventAggregator agg = new EventAggregator(this.args.threads, this.args.total);
        long threadStates = 0L;
        if (this.args.state != null) {
            for (String state : this.args.state.split(",")) {
                int key = this.jfr.getEnumKey("jdk.types.ThreadState", "STATE_" + state.toUpperCase());
                if (key < 0) continue;
                threadStates |= 1L << key;
            }
        }
        long startTicks = this.args.from != 0L ? this.toTicks(this.args.from) : Long.MIN_VALUE;
        long l = endTicks = this.args.to != 0L ? this.toTicks(this.args.to) : Long.MAX_VALUE;
        while ((event = this.jfr.readEvent(eventClass)) != null) {
            if (event.time < startTicks || event.time > endTicks || threadStates != 0L && (threadStates & 1L << ((ExecutionSample)event).threadState) == 0L) continue;
            agg.collect(event);
        }
        final Dictionary<String> methodNames = new Dictionary<String>();
        final Classifier classifier = new Classifier(methodNames);
        final double ticksToNanos = 1.0E9 / (double)this.jfr.ticksPerSec;
        final boolean scale = this.args.total && this.args.lock && ticksToNanos != 1.0;
        agg.forEach(new EventAggregator.Visitor(){

            @Override
            public void visit(Event event, long value) {
                StackTrace stackTrace = ((jfr2flame)jfr2flame.this).jfr.stackTraces.get(event.stackTraceId);
                if (stackTrace != null) {
                    Arguments args = jfr2flame.this.args;
                    long[] methods = stackTrace.methods;
                    byte[] types = stackTrace.types;
                    int[] locations = stackTrace.locations;
                    String classFrame = jfr2flame.this.getClassFrame(event);
                    String[] trace = new String[methods.length + (args.threads ? 1 : 0) + (args.classify ? 1 : 0) + (classFrame != null ? 1 : 0)];
                    if (args.threads) {
                        trace[0] = jfr2flame.this.getThreadFrame(event.tid);
                    }
                    int idx = trace.length;
                    if (classFrame != null) {
                        trace[--idx] = classFrame;
                    }
                    for (int i = 0; i < methods.length; ++i) {
                        int location;
                        String methodName = jfr2flame.this.getMethodName(methodNames, methods[i], types[i]);
                        if (args.lines && (location = locations[i] >>> 16) != 0) {
                            methodName = methodName + ":" + location;
                        } else if (args.bci && (location = locations[i] & 0xFFFF) != 0) {
                            methodName = methodName + "@" + location;
                        }
                        trace[--idx] = methodName + FRAME_SUFFIX[types[i]];
                    }
                    if (args.classify) {
                        trace[--idx] = classifier.getCategoryName(stackTrace);
                    }
                    fg.addSample(trace, scale ? (long)((double)value * ticksToNanos) : value);
                }
            }
        });
    }

    private String getThreadFrame(int tid) {
        String threadName = this.jfr.threads.get(tid);
        return threadName == null ? "[tid=" + tid + ']' : (threadName.startsWith("[tid=") ? threadName : '[' + threadName + " tid=" + tid + ']');
    }

    private String getClassFrame(Event event) {
        String suffix;
        long classId;
        if (event instanceof AllocationSample) {
            classId = ((AllocationSample)event).classId;
            suffix = ((AllocationSample)event).tlabSize == 0L ? "_[k]" : "_[i]";
        } else if (event instanceof ContendedLock) {
            classId = ((ContendedLock)event).classId;
            suffix = "_[i]";
        } else if (event instanceof LiveObject) {
            classId = ((LiveObject)event).classId;
            suffix = "_[i]";
        } else {
            return null;
        }
        ClassRef cls = this.jfr.classes.get(classId);
        if (cls == null) {
            return "null";
        }
        byte[] className = this.jfr.symbols.get(cls.name);
        int arrayDepth = 0;
        while (className[arrayDepth] == 91) {
            ++arrayDepth;
        }
        StringBuilder sb = new StringBuilder(this.toJavaClassName(className, arrayDepth, true));
        while (arrayDepth-- > 0) {
            sb.append("[]");
        }
        return sb.append(suffix).toString();
    }

    private String getMethodName(Dictionary<String> methodNames, long methodId, byte methodType) {
        String result = methodNames.get(methodId);
        if (result != null) {
            return result;
        }
        MethodRef method = this.jfr.methods.get(methodId);
        if (method == null) {
            result = "unknown";
        } else {
            ClassRef cls = this.jfr.classes.get(method.cls);
            byte[] className = this.jfr.symbols.get(cls.name);
            byte[] methodName = this.jfr.symbols.get(method.name);
            if (className == null || className.length == 0 || this.isNativeFrame(methodType)) {
                result = new String(methodName, StandardCharsets.UTF_8);
            } else {
                String classStr = this.toJavaClassName(className, 0, this.args.dot);
                String methodStr = new String(methodName, StandardCharsets.UTF_8);
                result = methodStr.isEmpty() ? classStr : classStr + '.' + methodStr;
            }
        }
        methodNames.put(methodId, result);
        return result;
    }

    private boolean isNativeFrame(byte methodType) {
        return methodType == 3 && this.jfr.getEnumValue("jdk.types.FrameType", 5) != null || methodType == 4 || methodType == 5;
    }

    private String toJavaClassName(byte[] symbol, int start, boolean dotted) {
        int i;
        int end = symbol.length;
        if (start > 0) {
            switch (symbol[start]) {
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 90: {
                    return "boolean";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 76: {
                    ++start;
                    --end;
                }
            }
        }
        if (this.args.norm) {
            for (i = end - 2; i > start; --i) {
                if (symbol[i] != 47 && symbol[i] != 46) continue;
                if (symbol[i + 1] < 48 || symbol[i + 1] > 57) break;
                end = i;
                if (i <= start + 19 || symbol[i - 19] != 43 || symbol[i - 18] != 48) break;
                end = i - 19;
                break;
            }
        }
        if (this.args.simple) {
            for (i = end - 2; i >= start; --i) {
                if (symbol[i] != 47 || symbol[i + 1] >= 48 && symbol[i + 1] <= 57) continue;
                start = i + 1;
                break;
            }
        }
        String s = new String(symbol, start, end - start, StandardCharsets.UTF_8);
        return dotted ? s.replace('/', '.') : s;
    }

    private long toTicks(long millis) {
        long nanos = millis * 1000000L;
        if (millis < 0L) {
            nanos += this.jfr.endNanos;
        } else if (millis < 1500000000000L) {
            nanos += this.jfr.startNanos;
        }
        return this.jfr.nanosToTicks(nanos);
    }

    public static void main(String[] cmdline) throws Exception {
        Arguments args = new Arguments(cmdline);
        if (args.input == null) {
            System.out.println("Usage: java " + jfr2flame.class.getName() + " [options] input.jfr [output.html]");
            System.out.println();
            System.out.println("options include all supported FlameGraph options, plus the following:");
            System.out.println("  --alloc       Allocation Flame Graph");
            System.out.println("  --live        Include only live objects in allocation profile");
            System.out.println("  --lock        Lock contention Flame Graph");
            System.out.println("  --threads     Split profile by threads");
            System.out.println("  --state LIST  Filter samples by thread states: RUNNABLE, SLEEPING, etc.");
            System.out.println("  --classify    Classify samples into predefined categories");
            System.out.println("  --total       Accumulate the total value (time, bytes, etc.)");
            System.out.println("  --lines       Show line numbers");
            System.out.println("  --bci         Show bytecode indices");
            System.out.println("  --simple      Simple class names instead of FQN");
            System.out.println("  --dot         Dotted class names");
            System.out.println("  --norm        Normalize names of hidden classes / lambdas");
            System.out.println("  --from TIME   Start time in ms (absolute or relative)");
            System.out.println("  --to TIME     End time in ms (absolute or relative)");
            System.out.println("  --collapsed   Use collapsed stacks output format");
            System.exit(1);
        }
        boolean collapsed = args.collapsed || args.output != null && args.output.endsWith(".collapsed");
        FlameGraph fg = collapsed ? new CollapsedStacks(args) : new FlameGraph(args);
        try (JfrReader jfr = new JfrReader(args.input);){
            new jfr2flame(jfr, args).convert(fg);
        }
        fg.dump();
    }
}

