/*
 * Decompiled with CFR 0.152.
 */
import one.jfr.Dictionary;
import one.jfr.StackTrace;

class Classifier {
    private static final String GC = "[gc]";
    private static final String JIT = "[jit]";
    private static final String VM = "[vm]";
    private static final String VTABLE_STUBS = "[vtable_stubs]";
    private static final String NATIVE = "[native]";
    private static final String INTERPRETER = "[Interpreter]_[0]";
    private static final String C1_COMP = "[c1_comp]_[1]";
    private static final String C2_COMP = "[c2_comp]_[i]";
    private static final String ADAPTER = "[c2i_adapter]_[i]";
    private static final String CLASS_INIT = "[class::init]";
    private static final String CLASS_LOAD = "[class::load]";
    private static final String CLASS_RESOLVE = "[class::resolve]";
    private static final String CLASS_VERIFY = "[class::verify]";
    private static final String LAMBDA_INIT = "[lambda::init]";
    private final Dictionary<String> methodNames;

    Classifier(Dictionary<String> methodNames) {
        this.methodNames = methodNames;
    }

    public String getCategoryName(StackTrace stackTrace) {
        long[] methods = stackTrace.methods;
        byte[] types = stackTrace.types;
        String category = this.detectGcJit(methods, types);
        if (category == null && (category = this.detectClassLoading(methods, types)) == null) {
            category = this.detectOther(methods, types);
        }
        return category;
    }

    private String detectGcJit(long[] methods, byte[] types) {
        boolean vmThread = false;
        int i = types.length;
        while (--i >= 0) {
            if (types[i] == 4) {
                switch (this.methodNames.get(methods[i])) {
                    case "CompileBroker::compiler_thread_loop": {
                        return JIT;
                    }
                    case "GCTaskThread::run": 
                    case "WorkerThread::run": {
                        return GC;
                    }
                    case "java_start": 
                    case "thread_native_entry": {
                        vmThread = true;
                    }
                }
                continue;
            }
            if (types[i] == 3) continue;
        }
        return vmThread ? VM : null;
    }

    private String detectClassLoading(long[] methods, byte[] types) {
        for (int i = 0; i < methods.length; ++i) {
            String methodName = this.methodNames.get(methods[i]);
            if (methodName.equals("Verifier::verify")) {
                return CLASS_VERIFY;
            }
            if (methodName.startsWith("InstanceKlass::initialize")) {
                return CLASS_INIT;
            }
            if (methodName.startsWith("LinkResolver::") || methodName.startsWith("InterpreterRuntime::resolve") || methodName.startsWith("SystemDictionary::resolve")) {
                return CLASS_RESOLVE;
            }
            if (methodName.endsWith("ClassLoader.loadClass")) {
                return CLASS_LOAD;
            }
            if (methodName.endsWith("LambdaMetafactory.metafactory") || methodName.endsWith("LambdaMetafactory.altMetafactory")) {
                return LAMBDA_INIT;
            }
            if (methodName.endsWith("table stub")) {
                return VTABLE_STUBS;
            }
            if (methodName.equals("Interpreter")) {
                return INTERPRETER;
            }
            if (!methodName.startsWith("I2C/C2I")) continue;
            return i + 1 < types.length && types[i + 1] == 0 ? INTERPRETER : ADAPTER;
        }
        return null;
    }

    private String detectOther(long[] methods, byte[] types) {
        boolean inJava = true;
        block18: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 0: {
                    return inJava ? INTERPRETER : NATIVE;
                }
                case 1: {
                    return inJava ? C2_COMP : NATIVE;
                }
                case 2: {
                    inJava = true;
                    continue block18;
                }
                case 3: {
                    String methodName = this.methodNames.get(methods[i]);
                    if (methodName.startsWith("JVM_") || methodName.startsWith("Unsafe_") || methodName.startsWith("MHN_") || methodName.startsWith("jni_")) {
                        return VM;
                    }
                    switch (methodName) {
                        case "call_stub": 
                        case "deoptimization": 
                        case "unknown_Java": 
                        case "not_walkable_Java": 
                        case "InlineCacheBuffer": {
                            return VM;
                        }
                    }
                    if (methodName.endsWith("_arraycopy") || methodName.contains("pthread_cond")) continue block18;
                    inJava = false;
                    continue block18;
                }
                case 4: {
                    String methodName = this.methodNames.get(methods[i]);
                    if (!methodName.startsWith("Runtime1::")) continue block18;
                    return C1_COMP;
                }
                case 6: {
                    return inJava ? C1_COMP : NATIVE;
                }
            }
        }
        return NATIVE;
    }
}

