/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpPreClient;
import com.linecorp.armeria.client.PreClient;
import com.linecorp.armeria.client.PreClientRequestContext;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.client.ClientUtil;
import com.linecorp.armeria.internal.client.DefaultClientRequestContext;
import com.linecorp.armeria.internal.client.grpc.protocol.InternalGrpcWebUtil;
import com.linecorp.armeria.internal.common.grpc.ForwardingCompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcLogUtil;
import com.linecorp.armeria.internal.common.grpc.GrpcMessageMarshaller;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.HttpStreamDeframer;
import com.linecorp.armeria.internal.common.grpc.InternalGrpcExceptionHandler;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.StatusAndMetadata;
import com.linecorp.armeria.internal.common.grpc.TimeoutHeaderUtil;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.armeria.unsafe.grpc.GrpcUnsafeBufferUtil;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Deadline;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArmeriaClientCall<I, O>
extends ClientCall<I, O>
implements Subscriber<DeframedMessage>,
TransportStatusListener {
    private static final Runnable NO_OP = () -> {};
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaClientCall.class);
    private static final AtomicIntegerFieldUpdater<ArmeriaClientCall> pendingMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(ArmeriaClientCall.class, "pendingMessages");
    private static final AtomicReferenceFieldUpdater<ArmeriaClientCall, Runnable> pendingTaskUpdater = AtomicReferenceFieldUpdater.newUpdater(ArmeriaClientCall.class, Runnable.class, "pendingTask");
    private final DefaultClientRequestContext ctx;
    private final BiFunction<ClientRequestContext, Throwable, HttpResponse> errorResponseFactory;
    private final HttpRequestWriter req;
    private final MethodDescriptor<I, O> method;
    private final Map<MethodDescriptor<?, ?>, String> simpleMethodNames;
    private final CallOptions callOptions;
    private final ArmeriaMessageFramer requestFramer;
    private final GrpcMessageMarshaller<I, O> marshaller;
    private final CompressorRegistry compressorRegistry;
    private final SerializationFormat serializationFormat;
    private final boolean unsafeWrapResponseBuffers;
    private final Executor executor;
    private final DecompressorRegistry decompressorRegistry;
    private final int maxInboundMessageSizeBytes;
    private final boolean grpcWebText;
    private final Compressor compressor;
    private final InternalGrpcExceptionHandler exceptionHandler;
    private final HttpPreClient preClient;
    private boolean endpointInitialized;
    @Nullable
    private volatile Runnable pendingTask;
    @Nullable
    private ClientCall.Listener<O> listener;
    @Nullable
    private Subscription upstream;
    @Nullable
    private O firstResponse;
    private boolean closed;
    private int pendingRequests;
    private volatile int pendingMessages;

    ArmeriaClientCall(DefaultClientRequestContext ctx, HttpRequestWriter req, MethodDescriptor<I, O> method, Map<MethodDescriptor<?, ?>, String> simpleMethodNames, int maxOutboundMessageSizeBytes, int maxInboundMessageSizeBytes, CallOptions callOptions, Compressor compressor, CompressorRegistry compressorRegistry, DecompressorRegistry decompressorRegistry, SerializationFormat serializationFormat, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapResponseBuffers, InternalGrpcExceptionHandler exceptionHandler, boolean useMethodMarshaller, HttpPreClient preClient, BiFunction<ClientRequestContext, Throwable, HttpResponse> errorResponseFactory) {
        this.ctx = ctx;
        this.req = req;
        this.method = method;
        this.simpleMethodNames = simpleMethodNames;
        this.callOptions = callOptions;
        this.compressor = compressor;
        this.compressorRegistry = compressorRegistry;
        this.decompressorRegistry = decompressorRegistry;
        this.serializationFormat = serializationFormat;
        this.unsafeWrapResponseBuffers = unsafeWrapResponseBuffers;
        this.grpcWebText = GrpcSerializationFormats.isGrpcWebText(serializationFormat);
        this.maxInboundMessageSizeBytes = maxInboundMessageSizeBytes;
        this.exceptionHandler = exceptionHandler;
        this.preClient = preClient;
        this.errorResponseFactory = errorResponseFactory;
        ctx.whenInitialized().handle((unused1, unused2) -> {
            this.runPendingTask();
            return null;
        });
        this.requestFramer = new ArmeriaMessageFramer(ctx.alloc(), maxOutboundMessageSizeBytes, this.grpcWebText);
        this.marshaller = new GrpcMessageMarshaller<I, O>(ctx.alloc(), serializationFormat, method, jsonMarshaller, unsafeWrapResponseBuffers, useMethodMarshaller);
        this.executor = callOptions.getExecutor() == null ? MoreExecutors.directExecutor() : MoreExecutors.newSequentialExecutor((Executor)callOptions.getExecutor());
        req.whenComplete().handle((unused1, unused2) -> {
            if (!ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(method, this.simpleMethodName()), null);
            }
            return null;
        });
    }

    public void start(ClientCall.Listener<O> responseListener, Metadata metadata) {
        long remainingNanos;
        Compressor compressor;
        Objects.requireNonNull(responseListener, "responseListener");
        Objects.requireNonNull(metadata, "metadata");
        this.listener = responseListener;
        if (this.callOptions.getCompressor() != null) {
            compressor = this.compressorRegistry.lookupCompressor(this.callOptions.getCompressor());
            if (compressor == null) {
                Status status = Status.INTERNAL.withDescription("Unable to find compressor by name " + this.callOptions.getCompressor());
                this.close(status, new Metadata());
                return;
            }
        } else {
            compressor = this.compressor;
        }
        this.requestFramer.setCompressor(ForwardingCompressor.forGrpc(compressor));
        if (this.callOptions.getDeadline() != null) {
            remainingNanos = this.callOptions.getDeadline().timeRemaining(TimeUnit.NANOSECONDS);
            if (remainingNanos <= 0L) {
                Status status = Status.DEADLINE_EXCEEDED.augmentDescription("ClientCall started after deadline exceeded: " + this.callOptions.getDeadline());
                this.close(status, new Metadata());
                return;
            }
            this.ctx.setResponseTimeout(TimeoutMode.SET_FROM_NOW, Duration.ofNanos(remainingNanos));
        } else {
            remainingNanos = this.ctx.remainingTimeoutNanos();
        }
        HttpRequest newReq = this.prepareHeaders(compressor, metadata, remainingNanos);
        HttpResponse res = (HttpResponse)ClientUtil.executeWithFallback((PreClient)this.preClient, (PreClientRequestContext)this.ctx, (Request)newReq, this.errorResponseFactory);
        HttpStreamDeframer deframer = new HttpStreamDeframer(this.decompressorRegistry, (RequestContext)this.ctx, this, this.exceptionHandler, this.maxInboundMessageSizeBytes, this.grpcWebText, false);
        StreamMessage deframed = res.decode((HttpDecoder)deframer, this.ctx.alloc());
        deframer.setDeframedStreamMessage((StreamMessage<DeframedMessage>)deframed);
        if (this.endpointInitialized) {
            deframed.subscribe((Subscriber)this, (EventExecutor)this.ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
        } else {
            this.addPendingTask(() -> deframed.subscribe((Subscriber)this, (EventExecutor)this.ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS}));
        }
        this.executor.execute(() -> {
            try (SafeCloseable ignored = this.ctx.push();){
                assert (this.listener != null);
                this.listener.onReady();
            }
            catch (Throwable t) {
                this.closeWhenListenerThrows(t);
            }
        });
    }

    public void request(int numMessages) {
        if (this.needsDirectInvocation()) {
            this.doRequest(numMessages);
        } else {
            this.execute(() -> this.doRequest(numMessages));
        }
    }

    private void doRequest(int numMessages) {
        if (this.method.getType().serverSendsOneMessage() && numMessages == 1) {
            numMessages = 2;
        }
        if (this.upstream == null) {
            this.pendingRequests += numMessages;
        } else {
            this.upstream.request((long)numMessages);
        }
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        if (this.needsDirectInvocation()) {
            this.doCancel(message, cause);
        } else {
            this.execute(() -> this.doCancel(message, cause));
        }
    }

    private void doCancel(@Nullable String message, @Nullable Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            logger.warn("Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.closed) {
            return;
        }
        Status status = Status.CANCELLED;
        if (message != null) {
            status = status.withDescription(message);
        }
        if (cause != null) {
            status = status.withCause(cause);
        }
        this.close(status, new Metadata());
        if (cause == null) {
            this.req.abort();
        } else {
            this.req.abort(cause);
        }
    }

    public void halfClose() {
        if (this.needsDirectInvocation()) {
            this.req.close();
        } else {
            this.execute(() -> ((HttpRequestWriter)this.req).close());
        }
    }

    public void sendMessage(I message) {
        pendingMessagesUpdater.incrementAndGet(this);
        if (this.needsDirectInvocation()) {
            this.doSendMessage(message);
        } else {
            this.execute(() -> this.doSendMessage(message));
        }
    }

    public boolean isReady() {
        return this.pendingMessages == 0;
    }

    private void doSendMessage(I message) {
        RequestLogAccess log = this.ctx.log();
        if (log.isComplete()) {
            return;
        }
        try {
            if (!log.isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName(), message), null);
            }
            ByteBuf serialized = this.marshaller.serializeRequest(message);
            this.req.write((Object)this.requestFramer.writePayload(serialized));
            this.req.whenConsumed().thenRun(() -> {
                if (pendingMessagesUpdater.decrementAndGet(this) == 0) {
                    this.executor.execute(() -> {
                        try (SafeCloseable ignored = this.ctx.push();){
                            assert (this.listener != null);
                            this.listener.onReady();
                        }
                        catch (Throwable t) {
                            this.closeWhenListenerThrows(t);
                        }
                    });
                }
            });
        }
        catch (Throwable t) {
            this.cancel(null, t);
        }
    }

    public synchronized void setMessageCompression(boolean enabled) {
        this.requestFramer.setMessageCompression(enabled);
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        this.upstream = subscription;
        if (this.pendingRequests > 0) {
            subscription.request((long)this.pendingRequests);
            this.pendingRequests = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(DeframedMessage message) {
        if (GrpcSerializationFormats.isGrpcWeb(this.serializationFormat) && message.isTrailer()) {
            ByteBuf buf;
            try {
                buf = InternalGrpcWebUtil.messageBuf((DeframedMessage)message, (ByteBufAllocator)this.ctx.alloc());
            }
            catch (Throwable t) {
                this.cancel(null, t);
                return;
            }
            try {
                HttpHeaders trailers = InternalGrpcWebUtil.parseGrpcWebTrailers((ByteBuf)buf);
                if (trailers == null) {
                    this.close(Status.INTERNAL.withDescription(this.serializationFormat.uriText() + " trailers malformed: " + buf.toString(StandardCharsets.UTF_8)), new Metadata());
                } else {
                    GrpcWebTrailers.set((RequestContext)this.ctx, (HttpHeaders)trailers);
                    GrpcStatus.reportStatus(trailers, this);
                }
            }
            finally {
                buf.release();
            }
            return;
        }
        try {
            boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(this.serializationFormat);
            O msg = this.marshaller.deserializeResponse(message, grpcWebText);
            if (this.firstResponse == null) {
                this.firstResponse = msg;
            }
            ByteBuf buf = message.buf();
            if (this.unsafeWrapResponseBuffers && buf != null && !grpcWebText) {
                GrpcUnsafeBufferUtil.storeBuffer(buf, msg, (RequestContext)this.ctx);
            }
            this.executor.execute(() -> {
                try (SafeCloseable ignored = this.ctx.push();){
                    assert (this.listener != null);
                    this.listener.onMessage(msg);
                }
                catch (Throwable t) {
                    this.closeWhenListenerThrows(t);
                }
            });
        }
        catch (Throwable t) {
            StatusAndMetadata statusAndMetadata = this.exceptionHandler.handle((RequestContext)this.ctx, t);
            this.close(statusAndMetadata.status(), statusAndMetadata.metadata());
        }
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
    }

    @Override
    public void transportReportStatus(Status status, @Nullable Metadata metadata) {
        this.executor.execute(() -> this.closeWhenEos(status, metadata));
    }

    @Override
    public void transportReportHeaders(Metadata metadata) {
        this.executor.execute(() -> {
            try (SafeCloseable ignored = this.ctx.push();){
                assert (this.listener != null);
                this.listener.onHeaders(metadata);
            }
            catch (Throwable t) {
                this.closeWhenListenerThrows(t);
            }
        });
    }

    private HttpRequest prepareHeaders(Compressor compressor, Metadata metadata, long remainingNanos) {
        Set availableEncodings;
        RequestHeadersBuilder newHeaders = this.req.headers().toBuilder();
        if (compressor != Codec.Identity.NONE) {
            newHeaders.set((CharSequence)GrpcHeaderNames.GRPC_ENCODING, compressor.getMessageEncoding());
        }
        if (!(availableEncodings = this.decompressorRegistry.getAdvertisedMessageEncodings()).isEmpty()) {
            newHeaders.add((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING, String.join((CharSequence)",", availableEncodings));
        }
        if (remainingNanos > 0L) {
            newHeaders.add((CharSequence)GrpcHeaderNames.GRPC_TIMEOUT, TimeoutHeaderUtil.toHeaderValue(remainingNanos));
        }
        MetadataUtil.fillHeaders(metadata, (HttpHeadersBuilder)newHeaders);
        HttpRequest newReq = this.req.withHeaders(newHeaders);
        this.ctx.updateRequest(newReq);
        return newReq;
    }

    private void closeWhenListenerThrows(Throwable t) {
        StatusAndMetadata statusAndMetadata = this.exceptionHandler.handle((RequestContext)this.ctx, t);
        this.closeWhenEos(statusAndMetadata.status(), statusAndMetadata.metadata());
    }

    private void closeWhenEos(Status status, @Nullable Metadata metadata) {
        if (this.needsDirectInvocation()) {
            this.close(status, metadata);
        } else {
            this.execute(() -> this.close(status, metadata));
        }
    }

    private void close(Status status, @Nullable Metadata metadata) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Deadline deadline = this.callOptions.getDeadline();
        if (status.getCode() == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
            status = Status.DEADLINE_EXCEEDED;
            metadata = new Metadata();
        } else if (metadata == null) {
            metadata = new Metadata();
        }
        if (status.getCode() == Status.Code.DEADLINE_EXCEEDED) {
            status = status.augmentDescription("deadline exceeded after " + TimeUnit.MILLISECONDS.toNanos(this.ctx.responseTimeoutMillis()) + "ns.");
        }
        StatusAndMetadata statusAndMetadata = new StatusAndMetadata(status, metadata);
        this.executor.execute(() -> {
            try (SafeCloseable ignored = this.ctx.push();){
                assert (this.listener != null);
                this.listener.onClose(statusAndMetadata.status(), statusAndMetadata.metadata());
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception while closing {}", this.listener, (Object)t);
            }
        });
        RequestLogBuilder logBuilder = this.ctx.logBuilder();
        logBuilder.responseContent((Object)GrpcLogUtil.rpcResponse(statusAndMetadata, this.firstResponse), null);
        if (!status.isOk()) {
            this.req.abort((Throwable)statusAndMetadata.asRuntimeException());
        }
        if (this.upstream != null) {
            this.upstream.cancel();
        }
    }

    private boolean needsDirectInvocation() {
        return this.endpointInitialized && this.ctx.eventLoop().inEventLoop();
    }

    private void execute(Runnable task) {
        if (this.endpointInitialized) {
            this.ctx.eventLoop().execute(task);
        } else {
            this.addPendingTask(task);
        }
    }

    private void runPendingTask() {
        block3: {
            Runnable pendingTask;
            this.endpointInitialized = true;
            while (!pendingTaskUpdater.compareAndSet(this, pendingTask = this.pendingTask, NO_OP)) {
            }
            if (pendingTask == null) break block3;
            if (this.ctx.eventLoop().inEventLoop()) {
                pendingTask.run();
            } else {
                this.ctx.eventLoop().execute(pendingTask);
            }
        }
    }

    private void addPendingTask(Runnable pendingTask) {
        block4: {
            Runnable newPendingTask;
            Runnable oldPendingTask;
            if (pendingTaskUpdater.compareAndSet(this, null, pendingTask)) break block4;
            do {
                oldPendingTask = this.pendingTask;
                assert (oldPendingTask != null);
                if (oldPendingTask != NO_OP) continue;
                if (this.ctx.eventLoop().inEventLoop()) {
                    pendingTask.run();
                } else {
                    this.ctx.eventLoop().execute(pendingTask);
                }
                break;
            } while (!pendingTaskUpdater.compareAndSet(this, oldPendingTask, newPendingTask = () -> {
                oldPendingTask.run();
                pendingTask.run();
            }));
        }
    }

    private String simpleMethodName() {
        String simpleMethodName = this.simpleMethodNames.get(this.method);
        if (simpleMethodName == null) {
            simpleMethodName = this.method.getBareMethodName();
        }
        return simpleMethodName;
    }
}

