/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelManipulator;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelInstaller
implements ModelCreator.CreatingListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelInstaller.class);
    protected final Client client;
    protected final ModuleManager moduleManager;

    @Override
    public void whenCreating(Model model) throws StorageException {
        if (RunningMode.isNoInitMode()) {
            InstallInfo info;
            while (!(info = this.isExists(model)).isAllExist()) {
                try {
                    log.info("install info: {}.table for model: [{}] not all required resources exist. OAP is running in 'no-init' mode, waiting create or update... retry 3s later.", (Object)info.buildInstallInfoMsg(), (Object)model.getName());
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage());
                }
            }
        } else {
            InstallInfo info = this.isExists(model);
            if (!info.isAllExist()) {
                log.info("install info: {}. table for model: [{}] not all required resources exist, creating or updating...", (Object)info.buildInstallInfoMsg(), (Object)model.getName());
                this.createTable(model);
            }
        }
    }

    public void start() {
    }

    protected final void overrideColumnName(String columnName, String newName) {
        ModelManipulator modelOverride = (ModelManipulator)this.moduleManager.find("core").provider().getService(ModelManipulator.class);
        modelOverride.overrideColumnName(columnName, newName);
    }

    public abstract InstallInfo isExists(Model var1) throws StorageException;

    public abstract void createTable(Model var1) throws StorageException;

    @Generated
    public ModelInstaller(Client client, ModuleManager moduleManager) {
        this.client = client;
        this.moduleManager = moduleManager;
    }

    public static abstract class InstallInfo {
        private final String modelName;
        private final boolean timeSeries;
        private final boolean superDataset;
        private final String modelType;
        private boolean allExist;

        protected InstallInfo(Model model) {
            this.modelName = model.getName();
            this.timeSeries = model.isTimeSeries();
            this.superDataset = model.isSuperDataset();
            this.modelType = model.isMetric() ? "metric" : (model.isRecord() ? "record" : "unknown");
        }

        public abstract String buildInstallInfoMsg();

        @Generated
        public String getModelName() {
            return this.modelName;
        }

        @Generated
        public boolean isTimeSeries() {
            return this.timeSeries;
        }

        @Generated
        public boolean isSuperDataset() {
            return this.superDataset;
        }

        @Generated
        public String getModelType() {
            return this.modelType;
        }

        @Generated
        public boolean isAllExist() {
            return this.allExist;
        }

        @Generated
        public void setAllExist(boolean allExist) {
            this.allExist = allExist;
        }
    }
}

