/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import lombok.Generated;

public @interface BanyanDB {

    public static enum TraceGroup {
        TRACE("trace"),
        ZIPKIN_TRACE("zipkinTrace"),
        NONE("none");

        private final String name;

        private TraceGroup(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static enum PropertyGroup {
        PROPERTY("property");

        private final String name;

        private PropertyGroup(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static enum MeasureGroup {
        METRICS_MINUTE("metricsMinute"),
        METRICS_HOUR("metricsHour"),
        METRICS_DAY("metricsDay"),
        METADATA("metadata");

        private final String name;

        private MeasureGroup(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    public static enum StreamGroup {
        RECORDS("records"),
        RECORDS_LOG("recordsLog"),
        RECORDS_BROWSER_ERROR_LOG("recordsBrowserErrorLog"),
        NONE("none");

        private final String name;

        private StreamGroup(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Group {
        public StreamGroup streamGroup() default StreamGroup.NONE;

        public TraceGroup traceGroup() default TraceGroup.NONE;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IndexMode {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EnableSort {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MatchQuery {
        public AnalyzerType analyzer();

        public static enum AnalyzerType {
            KEYWORD,
            STANDARD,
            SIMPLE,
            URL;

        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MeasureField {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Trace {

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        @Repeatable(value=List.class)
        public static @interface IndexRule {
            public String name();

            public String[] columns();

            public String orderByColumn();

            @Target(value={ElementType.TYPE})
            @Retention(value=RetentionPolicy.RUNTIME)
            public static @interface List {
                public IndexRule[] value();
            }
        }

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface SpanIdColumn {
            public String value();
        }

        @Target(value={ElementType.TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface TraceIdColumn {
            public String value();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TimestampColumn {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IndexRule {
        public IndexType indexType() default IndexType.INVERTED;

        public static enum IndexType {
            INVERTED,
            SKIPPING,
            TREE;

        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NoIndexing {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ShardingKey {
        public int index() default -1;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SeriesID {
        public int index() default -1;
    }
}

