/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.HashSet;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.EndpointNode;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.source.DetectPoint;

public class EndpointTopologyBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointTopology buildDebuggable(List<Call.CallDetail> serverSideCalls) {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Build endpoint topology");
            }
            EndpointTopology endpointTopology = this.build(serverSideCalls);
            return endpointTopology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    EndpointTopology build(List<Call.CallDetail> serverSideCalls) {
        EndpointTopology topology = new EndpointTopology();
        serverSideCalls.forEach(callDetail -> {
            Call call = new Call();
            call.setId(callDetail.getId());
            call.setSource(callDetail.getSource());
            call.setTarget(callDetail.getTarget());
            call.addDetectPoint(DetectPoint.SERVER);
            topology.getCalls().add(call);
        });
        HashSet nodeIds = new HashSet();
        serverSideCalls.forEach(call -> {
            if (!nodeIds.contains(call.getSource())) {
                topology.getNodes().add(this.buildEndpointDependencyNode(call.getSource()));
                nodeIds.add(call.getSource());
            }
            if (!nodeIds.contains(call.getTarget())) {
                topology.getNodes().add(this.buildEndpointDependencyNode(call.getTarget()));
                nodeIds.add(call.getTarget());
            }
        });
        return topology;
    }

    private EndpointNode buildEndpointDependencyNode(String endpointId) {
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        EndpointNode instanceNode = new EndpointNode();
        instanceNode.setId(endpointId);
        instanceNode.setName(endpointIDDefinition.getEndpointName());
        instanceNode.setServiceId(endpointIDDefinition.getServiceId());
        IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
        instanceNode.setServiceName(serviceIDDefinition.getName());
        instanceNode.setReal(serviceIDDefinition.isReal());
        return instanceNode;
    }
}

