/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.pprof.storage;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="pprof_profiling_data", scopeId=93, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="upload_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class PprofProfilingDataRecord
extends Record {
    public static final String INDEX_NAME = "pprof_profiling_data";
    public static final String TASK_ID = "task_id";
    public static final String INSTANCE_ID = "instance_id";
    public static final String DATA_BINARY = "data_binary";
    public static final String UPLOAD_TIME = "upload_time";
    @Column(name="task_id")
    private String taskId;
    @Column(name="instance_id")
    @BanyanDB.SeriesID(index=0)
    private String instanceId;
    @Column(name="upload_time")
    private long uploadTime;
    @Column(name="data_binary", storageOnly=true)
    private byte[] dataBinary;

    @Override
    public StorageID id() {
        return new StorageID().append(Hashing.sha256().newHasher().putString((CharSequence)this.taskId, StandardCharsets.UTF_8).putString((CharSequence)this.instanceId, StandardCharsets.UTF_8).putLong(this.uploadTime).hash().toString());
    }

    @Generated
    public PprofProfilingDataRecord() {
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public long getUploadTime() {
        return this.uploadTime;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PprofProfilingDataRecord)) {
            return false;
        }
        PprofProfilingDataRecord other = (PprofProfilingDataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        return Arrays.equals(this.getDataBinary(), other.getDataBinary());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PprofProfilingDataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getDataBinary());
        return result;
    }

    @Generated
    public String toString() {
        return "PprofProfilingDataRecord(taskId=" + this.getTaskId() + ", instanceId=" + this.getInstanceId() + ", uploadTime=" + this.getUploadTime() + ", dataBinary=" + Arrays.toString(this.getDataBinary()) + ")";
    }

    public static class Builder
    implements StorageBuilder<PprofProfilingDataRecord> {
        @Override
        public PprofProfilingDataRecord storage2Entity(Convert2Entity converter) {
            PprofProfilingDataRecord dataTraffic = new PprofProfilingDataRecord();
            dataTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            dataTraffic.setTaskId((String)converter.get(PprofProfilingDataRecord.TASK_ID));
            dataTraffic.setInstanceId((String)converter.get(PprofProfilingDataRecord.INSTANCE_ID));
            dataTraffic.setUploadTime(((Number)converter.get(PprofProfilingDataRecord.UPLOAD_TIME)).longValue());
            dataTraffic.setDataBinary(converter.getBytes(PprofProfilingDataRecord.DATA_BINARY));
            return dataTraffic;
        }

        @Override
        public void entity2Storage(PprofProfilingDataRecord storageData, Convert2Storage converter) {
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(PprofProfilingDataRecord.TASK_ID, storageData.getTaskId());
            converter.accept(PprofProfilingDataRecord.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(PprofProfilingDataRecord.UPLOAD_TIME, storageData.getUploadTime());
            converter.accept(PprofProfilingDataRecord.DATA_BINARY, storageData.getDataBinary());
        }
    }
}

