/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.oal.rt;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public abstract class OALDefine {
    private final String configFile;
    private final String sourcePackage;
    private final String dynamicMetricsClassPackage;
    private final String dynamicMetricsBuilderClassPackage;
    private final String dynamicDispatcherClassPackage;

    protected OALDefine(String configFile, String sourcePackage) {
        this(configFile, sourcePackage, "");
    }

    protected OALDefine(String configFile, String sourcePackage, String catalog) {
        this.configFile = Objects.requireNonNull(configFile);
        this.sourcePackage = this.appendPoint(Objects.requireNonNull(sourcePackage));
        this.dynamicMetricsClassPackage = "org.apache.skywalking.oap.server.core.source.oal.rt.metrics.";
        this.dynamicMetricsBuilderClassPackage = "org.apache.skywalking.oap.server.core.source.oal.rt.metrics.builder.";
        this.dynamicDispatcherClassPackage = StringUtil.isBlank((String)catalog) ? "org.apache.skywalking.oap.server.core.source.oal.rt.dispatcher." : "org.apache.skywalking.oap.server.core.source.oal.rt.dispatcher." + catalog;
    }

    private String appendPoint(String classPackage) {
        if (classPackage.endsWith(".")) {
            return classPackage;
        }
        return classPackage + ".";
    }

    @Generated
    public String getConfigFile() {
        return this.configFile;
    }

    @Generated
    public String getSourcePackage() {
        return this.sourcePackage;
    }

    @Generated
    public String getDynamicMetricsClassPackage() {
        return this.dynamicMetricsClassPackage;
    }

    @Generated
    public String getDynamicMetricsBuilderClassPackage() {
        return this.dynamicMetricsBuilderClassPackage;
    }

    @Generated
    public String getDynamicDispatcherClassPackage() {
        return this.dynamicDispatcherClassPackage;
    }

    @Generated
    public String toString() {
        return "OALDefine(configFile=" + this.getConfigFile() + ", sourcePackage=" + this.getSourcePackage() + ", dynamicMetricsClassPackage=" + this.getDynamicMetricsClassPackage() + ", dynamicMetricsBuilderClassPackage=" + this.getDynamicMetricsBuilderClassPackage() + ", dynamicDispatcherClassPackage=" + this.getDynamicDispatcherClassPackage() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OALDefine)) {
            return false;
        }
        OALDefine other = (OALDefine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$configFile = this.getConfigFile();
        String other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
            return false;
        }
        String this$sourcePackage = this.getSourcePackage();
        String other$sourcePackage = other.getSourcePackage();
        if (this$sourcePackage == null ? other$sourcePackage != null : !this$sourcePackage.equals(other$sourcePackage)) {
            return false;
        }
        String this$dynamicMetricsClassPackage = this.getDynamicMetricsClassPackage();
        String other$dynamicMetricsClassPackage = other.getDynamicMetricsClassPackage();
        if (this$dynamicMetricsClassPackage == null ? other$dynamicMetricsClassPackage != null : !this$dynamicMetricsClassPackage.equals(other$dynamicMetricsClassPackage)) {
            return false;
        }
        String this$dynamicMetricsBuilderClassPackage = this.getDynamicMetricsBuilderClassPackage();
        String other$dynamicMetricsBuilderClassPackage = other.getDynamicMetricsBuilderClassPackage();
        if (this$dynamicMetricsBuilderClassPackage == null ? other$dynamicMetricsBuilderClassPackage != null : !this$dynamicMetricsBuilderClassPackage.equals(other$dynamicMetricsBuilderClassPackage)) {
            return false;
        }
        String this$dynamicDispatcherClassPackage = this.getDynamicDispatcherClassPackage();
        String other$dynamicDispatcherClassPackage = other.getDynamicDispatcherClassPackage();
        return !(this$dynamicDispatcherClassPackage == null ? other$dynamicDispatcherClassPackage != null : !this$dynamicDispatcherClassPackage.equals(other$dynamicDispatcherClassPackage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OALDefine;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
        String $sourcePackage = this.getSourcePackage();
        result = result * 59 + ($sourcePackage == null ? 43 : $sourcePackage.hashCode());
        String $dynamicMetricsClassPackage = this.getDynamicMetricsClassPackage();
        result = result * 59 + ($dynamicMetricsClassPackage == null ? 43 : $dynamicMetricsClassPackage.hashCode());
        String $dynamicMetricsBuilderClassPackage = this.getDynamicMetricsBuilderClassPackage();
        result = result * 59 + ($dynamicMetricsBuilderClassPackage == null ? 43 : $dynamicMetricsBuilderClassPackage.hashCode());
        String $dynamicDispatcherClassPackage = this.getDynamicDispatcherClassPackage();
        result = result * 59 + ($dynamicDispatcherClassPackage == null ? 43 : $dynamicDispatcherClassPackage.hashCode());
        return result;
    }
}

