/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.ExportRecordWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordPersistentWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordStreamProcessor
implements StreamProcessor<Record> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordStreamProcessor.class);
    private static final RecordStreamProcessor PROCESSOR = new RecordStreamProcessor();
    private Map<Class<? extends Record>, RecordPersistentWorker> workers = new HashMap<Class<? extends Record>, RecordPersistentWorker>();
    private int recordDataTTL;
    private final boolean isTestingTTL = "true".equalsIgnoreCase(System.getenv("TESTING_TTL"));

    public static RecordStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(Record record) {
        long recordTimestamp;
        boolean isExpired;
        long now = System.currentTimeMillis();
        boolean bl = isExpired = now - (recordTimestamp = TimeBucket.getTimestamp(record.getTimeBucket(), DownSampling.Minute)) > TimeUnit.DAYS.toMicros(this.recordDataTTL);
        if (isExpired && !this.isTestingTTL) {
            log.debug("Receiving expired record: {}, time: {}, ignored", (Object)record.id(), (Object)record.getTimeBucket());
            return;
        }
        RecordPersistentWorker worker = this.workers.get(record.getClass());
        if (worker != null) {
            worker.in(record);
        }
    }

    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends Record> recordClass) throws StorageException {
        IRecordDAO recordDAO;
        StorageBuilderFactory storageBuilderFactory = (StorageBuilderFactory)moduleDefineHolder.find("storage").provider().getService(StorageBuilderFactory.class);
        Class<? extends StorageBuilder> builder = storageBuilderFactory.builderOf(recordClass, stream.builder());
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            recordDAO = storageDAO.newRecordDao(builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " record DAO failure.", e);
        }
        ModelCreator modelSetter = (ModelCreator)moduleDefineHolder.find("core").provider().getService(ModelCreator.class);
        Model model = modelSetter.add(recordClass, stream.scopeId(), new Storage(stream.name(), false, DownSampling.Second));
        ExportRecordWorker exportWorker = new ExportRecordWorker(moduleDefineHolder);
        RecordPersistentWorker persistentWorker = new RecordPersistentWorker(moduleDefineHolder, model, recordDAO, exportWorker);
        this.workers.put(recordClass, persistentWorker);
    }

    @Generated
    public void setRecordDataTTL(int recordDataTTL) {
        this.recordDataTTL = recordDataTTL;
    }
}

