/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.topn;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.ComparableStorageData;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;

public abstract class TopN
extends Record
implements ComparableStorageData {
    public static final String STATEMENT = "statement";
    public static final String LATENCY = "latency";
    public static final String TRACE_ID = "trace_id";
    public static final String ENTITY_ID = "entity_id";
    public static final String TIMESTAMP = "timestamp";
    @ElasticSearch.EnableDocValues
    @BanyanDB.EnableSort
    @Column(name="latency", dataType=Column.ValueDataType.SAMPLED_RECORD)
    private long latency;
    @Column(name="trace_id", storageOnly=true)
    private String traceId;
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;

    public int compareTo(Object o) {
        TopN target = (TopN)o;
        return (int)(this.latency - target.latency);
    }

    @Generated
    public long getLatency() {
        return this.latency;
    }

    @Generated
    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

