/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SpanLayer;
import org.apache.skywalking.apm.network.language.agent.v3.SpanObject;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.vservice.VirtualServiceProcessor;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.CacheAccess;
import org.apache.skywalking.oap.server.core.source.CacheSlowAccess;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.VirtualCacheOperation;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCacheProcessor
implements VirtualServiceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VirtualCacheProcessor.class);
    private final NamingControl namingControl;
    private final AnalyzerModuleConfig config;
    private final List<Source> sourceList = new ArrayList<Source>();

    @Override
    public void prepareVSIfNecessary(SpanObject span, SegmentObject segmentObject) {
        if (span.getSpanLayer() != SpanLayer.Cache) {
            return;
        }
        Map<String, String> tags = span.getTagsList().stream().collect(Collectors.toMap(KeyStringValuePair::getKey, KeyStringValuePair::getValue));
        String cacheType = tags.get("cache.type");
        if (StringUtil.isBlank((String)cacheType)) {
            return;
        }
        cacheType = cacheType.toLowerCase();
        Object peer = span.getPeer();
        if (StringUtil.isBlank((String)peer)) {
            peer = tags.get("cache.type") + "-local";
        }
        long timeBucket = TimeBucket.getMinuteTimeBucket((long)span.getStartTime());
        String serviceName = this.namingControl.formatServiceName((String)peer);
        int latency = (int)(span.getEndTime() - span.getStartTime());
        this.sourceList.add((Source)this.parseServiceMeta(serviceName, timeBucket));
        VirtualCacheOperation op = this.parseOperation(tags.get("cache.op"));
        if (op == VirtualCacheOperation.Write && latency > this.config.getCacheWriteLatencyThresholdsAndWatcher().getThreshold(cacheType) || op == VirtualCacheOperation.Read && latency > this.config.getCacheReadLatencyThresholdsAndWatcher().getThreshold(cacheType)) {
            CacheSlowAccess slowAccess = new CacheSlowAccess();
            slowAccess.setCacheServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)false));
            slowAccess.setLatency((long)latency);
            slowAccess.setId(segmentObject.getTraceSegmentId() + "-" + span.getSpanId());
            slowAccess.setStatus(!span.getIsError());
            slowAccess.setTraceId(segmentObject.getTraceId());
            slowAccess.setCommand(tags.get("cache.cmd"));
            slowAccess.setKey(tags.get("cache.key"));
            slowAccess.setTimeBucket(TimeBucket.getRecordTimeBucket((long)span.getStartTime()));
            slowAccess.setTimestamp(span.getStartTime());
            slowAccess.setOperation(op);
            this.sourceList.add((Source)slowAccess);
        }
        CacheAccess access = new CacheAccess();
        access.setCacheTypeId(span.getComponentId());
        access.setLatency(latency);
        access.setName(serviceName);
        access.setStatus(!span.getIsError());
        access.setTimeBucket(timeBucket);
        access.setOperation(op);
        this.sourceList.add((Source)access);
    }

    private ServiceMeta parseServiceMeta(String serviceName, long timeBucket) {
        ServiceMeta service = new ServiceMeta();
        service.setName(serviceName);
        service.setLayer(Layer.VIRTUAL_CACHE);
        service.setTimeBucket(timeBucket);
        return service;
    }

    private VirtualCacheOperation parseOperation(String op) {
        if ("write".equals(op)) {
            return VirtualCacheOperation.Write;
        }
        if ("read".equals(op)) {
            return VirtualCacheOperation.Read;
        }
        return VirtualCacheOperation.Others;
    }

    @Override
    public void emitTo(Consumer<Source> consumer) {
        this.sourceList.forEach(consumer);
    }

    @Generated
    public VirtualCacheProcessor(NamingControl namingControl, AnalyzerModuleConfig config) {
        this.namingControl = namingControl;
        this.config = config;
    }
}

