/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class FieldsHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldsHelper.class);
    private static final Map<Class<?>, FieldsHelper> HELPER_MAP = new ConcurrentHashMap();
    private final Class<?> targetClass;
    private boolean initialized = false;
    private Map<String, FieldFormat> fieldNameMapping;
    private Map<String, BiConsumer<Object, String>> fieldSetterMapping;

    public static FieldsHelper forClass(Class<?> targetClass) {
        return HELPER_MAP.computeIfAbsent(targetClass, FieldsHelper::new);
    }

    private FieldsHelper(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void init(String file) throws Exception {
        this.init(ResourceUtils.readToStream(file));
    }

    public void init(InputStream inputStream) {
        if (this.initialized) {
            return;
        }
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(inputStream);
        this.fieldNameMapping = new HashMap<String, FieldFormat>(config.size());
        this.fieldSetterMapping = new HashMap<String, BiConsumer<Object, String>>(config.size());
        for (Map.Entry entry : config.entrySet()) {
            String serviceMetaInfoFieldName = (String)entry.getKey();
            String flatBuffersFieldName = (String)entry.getValue();
            Pattern p = Pattern.compile("(\\$\\{(?<properties>.+?)})");
            Matcher m = p.matcher(flatBuffersFieldName);
            ArrayList<Property> flatBuffersFieldNames = new ArrayList<Property>(m.groupCount());
            StringBuffer serviceNamePattern = new StringBuffer();
            while (m.find()) {
                String properties = m.group("properties");
                List<Field> fields = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)properties).stream().map(candidate -> {
                    List tokens = Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)candidate);
                    StringBuilder tokenBuffer = new StringBuilder();
                    ArrayList<String> candidateFields = new ArrayList<String>(tokens.size());
                    for (String token : tokens) {
                        if (tokenBuffer.length() == 0 && token.startsWith("\"")) {
                            tokenBuffer.append(token);
                        } else if (tokenBuffer.length() > 0) {
                            tokenBuffer.append(".").append(token);
                        } else {
                            candidateFields.add(token);
                        }
                        if (tokenBuffer.length() <= 0 || !token.endsWith("\"")) continue;
                        candidateFields.add(tokenBuffer.toString().replaceAll("\"", ""));
                        tokenBuffer.setLength(0);
                    }
                    return new Field(candidateFields);
                }).collect(Collectors.toList());
                flatBuffersFieldNames.add(new Property(fields));
                m.appendReplacement(serviceNamePattern, "%s");
            }
            this.fieldNameMapping.put(serviceMetaInfoFieldName, new FieldFormat(serviceNamePattern.toString(), flatBuffersFieldNames));
            try {
                String setter = "set" + StringUtils.capitalize((String)serviceMetaInfoFieldName);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<String> parameterType = String.class;
                CallSite site = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class), MethodType.methodType(Void.TYPE, Object.class, Object.class), lookup.findVirtual(this.targetClass, setter, MethodType.methodType(Void.TYPE, parameterType)), MethodType.methodType(Void.TYPE, this.targetClass, parameterType));
                MethodHandle factory = site.getTarget();
                BiConsumer method = factory.invoke();
                this.fieldSetterMapping.put(serviceMetaInfoFieldName, method);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Initialize method error", e);
            }
        }
        this.initialized = true;
    }

    public void inflate(Struct metadata, Object target) {
        Value empty = Value.newBuilder().setStringValue("-").build();
        Value root = Value.newBuilder().setStructValue(metadata).build();
        for (Map.Entry<String, FieldFormat> entry : this.fieldNameMapping.entrySet()) {
            FieldFormat fieldFormat = entry.getValue();
            Object[] values = new String[fieldFormat.properties.size()];
            block1: for (int i = 0; i < fieldFormat.properties.size(); ++i) {
                values[i] = "-";
                Property property = fieldFormat.properties.get(i);
                for (Field field : property) {
                    Value value = root;
                    for (String segment : field.dsvSegments) {
                        TreeMap fieldMaps = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                        fieldMaps.putAll(value.getStructValue().getFieldsMap());
                        value = fieldMaps.getOrDefault(segment, empty);
                    }
                    if (Strings.isNullOrEmpty((String)value.getStringValue()) || "-".equals(value.getStringValue())) continue;
                    values[i] = value.getStringValue();
                    continue block1;
                }
            }
            String value = Strings.lenientFormat((String)fieldFormat.format, (Object[])values);
            if (Strings.isNullOrEmpty((String)value)) continue;
            this.fieldSetterMapping.get(entry.getKey()).accept(target, value);
        }
    }

    private static class Property
    implements Iterable<Field> {
        private final List<Field> candidateFields;

        @Generated
        public Property(List<Field> candidateFields) {
            this.candidateFields = candidateFields;
        }

        @Generated
        public int size() {
            return this.candidateFields.size();
        }

        @Generated
        public boolean isEmpty() {
            return this.candidateFields.isEmpty();
        }

        @Generated
        public boolean contains(Object arg0) {
            return this.candidateFields.contains(arg0);
        }

        @Override
        @Generated
        public Iterator<Field> iterator() {
            return this.candidateFields.iterator();
        }

        @Generated
        public Object[] toArray() {
            return this.candidateFields.toArray();
        }

        @Generated
        public <T> T[] toArray(T[] arg0) {
            return this.candidateFields.toArray(arg0);
        }

        @Generated
        public boolean add(Field arg0) {
            return this.candidateFields.add(arg0);
        }

        @Generated
        public boolean remove(Object arg0) {
            return this.candidateFields.remove(arg0);
        }

        @Generated
        public boolean containsAll(Collection<?> arg0) {
            return this.candidateFields.containsAll(arg0);
        }

        @Generated
        public boolean addAll(Collection<? extends Field> arg0) {
            return this.candidateFields.addAll(arg0);
        }

        @Generated
        public boolean addAll(int arg0, Collection<? extends Field> arg1) {
            return this.candidateFields.addAll(arg0, arg1);
        }

        @Generated
        public boolean removeAll(Collection<?> arg0) {
            return this.candidateFields.removeAll(arg0);
        }

        @Generated
        public boolean retainAll(Collection<?> arg0) {
            return this.candidateFields.retainAll(arg0);
        }

        @Generated
        public void replaceAll(UnaryOperator<Field> operator) {
            this.candidateFields.replaceAll(operator);
        }

        @Generated
        public void sort(Comparator<? super Field> c) {
            this.candidateFields.sort(c);
        }

        @Generated
        public void clear() {
            this.candidateFields.clear();
        }

        @Generated
        public Field get(int arg0) {
            return this.candidateFields.get(arg0);
        }

        @Generated
        public Field set(int arg0, Field arg1) {
            return this.candidateFields.set(arg0, arg1);
        }

        @Generated
        public void add(int arg0, Field arg1) {
            this.candidateFields.add(arg0, arg1);
        }

        @Generated
        public Field remove(int arg0) {
            return this.candidateFields.remove(arg0);
        }

        @Generated
        public int indexOf(Object arg0) {
            return this.candidateFields.indexOf(arg0);
        }

        @Generated
        public int lastIndexOf(Object arg0) {
            return this.candidateFields.lastIndexOf(arg0);
        }

        @Generated
        public ListIterator<Field> listIterator() {
            return this.candidateFields.listIterator();
        }

        @Generated
        public ListIterator<Field> listIterator(int arg0) {
            return this.candidateFields.listIterator(arg0);
        }

        @Generated
        public List<Field> subList(int arg0, int arg1) {
            return this.candidateFields.subList(arg0, arg1);
        }

        @Override
        @Generated
        public Spliterator<Field> spliterator() {
            return this.candidateFields.spliterator();
        }

        @Generated
        public void addFirst(Field e) {
            this.candidateFields.addFirst(e);
        }

        @Generated
        public void addLast(Field e) {
            this.candidateFields.addLast(e);
        }

        @Generated
        public Field getFirst() {
            return this.candidateFields.getFirst();
        }

        @Generated
        public Field getLast() {
            return this.candidateFields.getLast();
        }

        @Generated
        public Field removeFirst() {
            return this.candidateFields.removeFirst();
        }

        @Generated
        public Field removeLast() {
            return this.candidateFields.removeLast();
        }

        @Generated
        public List<Field> reversed() {
            return this.candidateFields.reversed();
        }

        @Generated
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.candidateFields.toArray(generator);
        }

        @Generated
        public boolean removeIf(Predicate<? super Field> filter) {
            return this.candidateFields.removeIf(filter);
        }

        @Generated
        public Stream<Field> stream() {
            return this.candidateFields.stream();
        }

        @Generated
        public Stream<Field> parallelStream() {
            return this.candidateFields.parallelStream();
        }

        @Override
        @Generated
        public void forEach(Consumer<? super Field> action) {
            this.candidateFields.forEach(action);
        }
    }

    private static class FieldFormat {
        private final String format;
        private final List<Property> properties;

        @Generated
        public FieldFormat(String format, List<Property> properties) {
            this.format = format;
            this.properties = properties;
        }
    }

    private static class Field
    implements Iterable<String> {
        private final List<String> dsvSegments;

        @Generated
        public Field(List<String> dsvSegments) {
            this.dsvSegments = dsvSegments;
        }

        @Generated
        public int size() {
            return this.dsvSegments.size();
        }

        @Generated
        public boolean isEmpty() {
            return this.dsvSegments.isEmpty();
        }

        @Generated
        public boolean contains(Object arg0) {
            return this.dsvSegments.contains(arg0);
        }

        @Override
        @Generated
        public Iterator<String> iterator() {
            return this.dsvSegments.iterator();
        }

        @Generated
        public Object[] toArray() {
            return this.dsvSegments.toArray();
        }

        @Generated
        public <T> T[] toArray(T[] arg0) {
            return this.dsvSegments.toArray(arg0);
        }

        @Generated
        public boolean add(String arg0) {
            return this.dsvSegments.add(arg0);
        }

        @Generated
        public boolean remove(Object arg0) {
            return this.dsvSegments.remove(arg0);
        }

        @Generated
        public boolean containsAll(Collection<?> arg0) {
            return this.dsvSegments.containsAll(arg0);
        }

        @Generated
        public boolean addAll(Collection<? extends String> arg0) {
            return this.dsvSegments.addAll(arg0);
        }

        @Generated
        public boolean addAll(int arg0, Collection<? extends String> arg1) {
            return this.dsvSegments.addAll(arg0, arg1);
        }

        @Generated
        public boolean removeAll(Collection<?> arg0) {
            return this.dsvSegments.removeAll(arg0);
        }

        @Generated
        public boolean retainAll(Collection<?> arg0) {
            return this.dsvSegments.retainAll(arg0);
        }

        @Generated
        public void replaceAll(UnaryOperator<String> operator) {
            this.dsvSegments.replaceAll(operator);
        }

        @Generated
        public void sort(Comparator<? super String> c) {
            this.dsvSegments.sort(c);
        }

        @Generated
        public void clear() {
            this.dsvSegments.clear();
        }

        @Generated
        public String get(int arg0) {
            return this.dsvSegments.get(arg0);
        }

        @Generated
        public String set(int arg0, String arg1) {
            return this.dsvSegments.set(arg0, arg1);
        }

        @Generated
        public void add(int arg0, String arg1) {
            this.dsvSegments.add(arg0, arg1);
        }

        @Generated
        public String remove(int arg0) {
            return this.dsvSegments.remove(arg0);
        }

        @Generated
        public int indexOf(Object arg0) {
            return this.dsvSegments.indexOf(arg0);
        }

        @Generated
        public int lastIndexOf(Object arg0) {
            return this.dsvSegments.lastIndexOf(arg0);
        }

        @Generated
        public ListIterator<String> listIterator() {
            return this.dsvSegments.listIterator();
        }

        @Generated
        public ListIterator<String> listIterator(int arg0) {
            return this.dsvSegments.listIterator(arg0);
        }

        @Generated
        public List<String> subList(int arg0, int arg1) {
            return this.dsvSegments.subList(arg0, arg1);
        }

        @Override
        @Generated
        public Spliterator<String> spliterator() {
            return this.dsvSegments.spliterator();
        }

        @Generated
        public void addFirst(String e) {
            this.dsvSegments.addFirst(e);
        }

        @Generated
        public void addLast(String e) {
            this.dsvSegments.addLast(e);
        }

        @Generated
        public String getFirst() {
            return this.dsvSegments.getFirst();
        }

        @Generated
        public String getLast() {
            return this.dsvSegments.getLast();
        }

        @Generated
        public String removeFirst() {
            return this.dsvSegments.removeFirst();
        }

        @Generated
        public String removeLast() {
            return this.dsvSegments.removeLast();
        }

        @Generated
        public List<String> reversed() {
            return this.dsvSegments.reversed();
        }

        @Generated
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.dsvSegments.toArray(generator);
        }

        @Generated
        public boolean removeIf(Predicate<? super String> filter) {
            return this.dsvSegments.removeIf(filter);
        }

        @Generated
        public Stream<String> stream() {
            return this.dsvSegments.stream();
        }

        @Generated
        public Stream<String> parallelStream() {
            return this.dsvSegments.parallelStream();
        }

        @Override
        @Generated
        public void forEach(Consumer<? super String> action) {
            this.dsvSegments.forEach(action);
        }
    }
}

