/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.query.type.trace.v2.TraceList;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TraceQueryV2
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TraceQueryService queryService;

    public TraceQueryV2(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TraceQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TraceQueryService)this.moduleManager.find("core").provider().getService(TraceQueryService.class);
        }
        return this.queryService;
    }

    public CompletableFuture<TraceList> queryTraces(TraceQueryCondition condition, boolean debug) throws IOException {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("TraceQueryCondition: " + String.valueOf(condition), debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query traces");
            try {
                TraceList traces = this.getQueryService().queryTraces(condition);
                if (debug) {
                    traces.setDebuggingTrace(traceContext.getExecTrace());
                }
                TraceList traceList = traces;
                return traceList;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<Boolean> hasQueryTracesV2Support() {
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().hasQueryTracesV2Support());
    }
}

