/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.profiling.pprof.PprofQueryService;
import org.apache.skywalking.oap.server.core.query.input.PprofAnalyzationRequest;
import org.apache.skywalking.oap.server.core.query.input.PprofTaskListRequest;
import org.apache.skywalking.oap.server.core.query.type.PprofAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.PprofStackTree;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskListResult;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskLogOperationType;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskProgress;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class PprofQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private PprofQueryService queryService;

    public PprofQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private PprofQueryService getPprofQueryService() {
        if (this.queryService == null) {
            this.queryService = (PprofQueryService)this.moduleManager.find("core").provider().getService(PprofQueryService.class);
        }
        return this.queryService;
    }

    public PprofTaskListResult queryPprofTaskList(PprofTaskListRequest request) throws IOException {
        List tasks = this.getPprofQueryService().queryTask(request.getServiceId(), request.getQueryDuration(), request.getLimit());
        return new PprofTaskListResult(null, tasks);
    }

    public PprofAnalyzation queryPprofAnalyze(PprofAnalyzationRequest request) throws IOException {
        PprofStackTree eventFrameTrees = this.getPprofQueryService().queryPprofData(request.getTaskId(), request.getInstanceIds());
        return new PprofAnalyzation(eventFrameTrees);
    }

    public PprofTaskProgress queryPprofTaskProgress(String taskId) throws IOException {
        PprofTaskProgress pprofTaskProgress = new PprofTaskProgress();
        List logs = this.getPprofQueryService().queryPprofTaskLogs(taskId);
        pprofTaskProgress.setLogs(logs);
        ArrayList errorInstances = new ArrayList();
        ArrayList successInstances = new ArrayList();
        logs.forEach(log -> {
            if (PprofTaskLogOperationType.EXECUTION_FINISHED.equals((Object)log.getOperationType())) {
                successInstances.add(log.getInstanceId());
            } else if (PprofTaskLogOperationType.EXECUTION_TASK_ERROR.equals((Object)log.getOperationType()) || PprofTaskLogOperationType.PPROF_UPLOAD_FILE_TOO_LARGE_ERROR.equals((Object)log.getOperationType())) {
                errorInstances.add(log.getInstanceId());
            }
        });
        pprofTaskProgress.setErrorInstanceIds(errorInstances);
        pprofTaskProgress.setSuccessInstanceIds(successInstances);
        return pprofTaskProgress;
    }
}

