/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import graphql.kickstart.tools.GraphQLQueryResolver;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.resolver.MetadataQueryV2;
import org.apache.skywalking.oap.query.graphql.type.InternalLog;
import org.apache.skywalking.oap.query.graphql.type.LogAdapter;
import org.apache.skywalking.oap.query.graphql.type.OndemandContainergQueryCondition;
import org.apache.skywalking.oap.query.graphql.type.OndemandLogQueryCondition;
import org.apache.skywalking.oap.query.graphql.type.PodContainers;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Attribute;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstance;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OndemandLogQuery
implements GraphQLQueryResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OndemandLogQuery.class);
    private final MetadataQueryV2 metadataQuery;

    public PodContainers listContainers(OndemandContainergQueryCondition condition) throws IOException {
        ServiceInstance instance = this.metadataQuery.getInstance(condition.getServiceInstanceId()).join();
        Map<String, String> attributesMap = this.convertInstancePropertiesToMap(instance);
        String ns = attributesMap.get("namespace");
        String pod = attributesMap.get("pod");
        return this.listContainers(ns, pod);
    }

    public Logs ondemandPodLogs(OndemandLogQueryCondition condition) throws IOException {
        ServiceInstance instance = this.metadataQuery.getInstance(condition.getServiceInstanceId()).join();
        Map<String, String> attributesMap = this.convertInstancePropertiesToMap(instance);
        String ns = attributesMap.get("namespace");
        String pod = attributesMap.get("pod");
        return this.ondemandPodLogs(ns, pod, condition);
    }

    protected Map<String, String> convertInstancePropertiesToMap(ServiceInstance instance) {
        if (instance == null) {
            return Collections.emptyMap();
        }
        List attributes = instance.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> attributesMap = attributes.stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        if (!attributesMap.containsKey("namespace") || !attributesMap.containsKey("pod")) {
            return Collections.emptyMap();
        }
        return attributesMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PodContainers listContainers(String namespace, String podName) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            if (Strings.isNullOrEmpty((String)namespace) || Strings.isNullOrEmpty((String)podName)) {
                PodContainers podContainers = new PodContainers().setErrorReason("namespace and podName can't be null or empty");
                return podContainers;
            }
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get();
            if (Objects.isNull(pod)) {
                PodContainers podContainers = new PodContainers().setErrorReason("No pod can be found");
                return podContainers;
            }
            PodSpec spec = pod.getSpec();
            if (Objects.isNull(spec)) {
                PodContainers podContainers = new PodContainers().setErrorReason("No pod spec can be found");
                return podContainers;
            }
            List<String> containers = spec.getContainers().stream().map(Container::getName).collect(Collectors.toList());
            if (Objects.nonNull(spec.getInitContainers())) {
                List init = spec.getInitContainers().stream().map(Container::getName).collect(Collectors.toList());
                containers.addAll(init);
            }
            PodContainers podContainers = new PodContainers().setContainers(containers);
            return podContainers;
        }
        catch (KubernetesClientException e) {
            log.error("Failed to list containers from Kubernetes, {}", (Object)e.getMessage(), (Object)e);
            return new PodContainers().setErrorReason(e.getMessage() + ": " + e.getCode());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Logs ondemandPodLogs(String namespace, String podName, OndemandLogQueryCondition condition) {
        if (Strings.isNullOrEmpty((String)namespace)) return new Logs().setErrorReason("namespace and podName can't be null or empty");
        if (Strings.isNullOrEmpty((String)podName)) {
            return new Logs().setErrorReason("namespace and podName can't be null or empty");
        }
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get();
            ObjectMeta podMetadata = pod.getMetadata();
            if (Objects.isNull(podMetadata)) {
                Logs logs = new Logs().setErrorReason("No pod metadata can be found");
                return logs;
            }
            PodSpec spec = pod.getSpec();
            if (Objects.isNull(spec)) {
                Logs logs = new Logs().setErrorReason("No pod spec can be found");
                return logs;
            }
            Duration duration = new Duration();
            duration.setStart(condition.getDuration().getStart());
            duration.setEnd(condition.getDuration().getEnd());
            duration.setStep(condition.getDuration().getStep());
            long since = (System.currentTimeMillis() - duration.getStartTimestamp()) / 1000L;
            since = since > 0L ? since : 1800L;
            String container = condition.getContainer();
            String podLog = ((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(podMetadata.getNamespace())).withName(podMetadata.getName())).inContainer((Object)container)).usingTimestamps().sinceSeconds((int)since).getLog();
            List<InternalLog> logs = Splitter.on((String)"\n").omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)podLog)).stream().filter(StringUtil::isNotBlank).map(it -> InternalLog.builder().line((String)it).container(container).build()).collect(Collectors.toList());
            List<Log> filtered = this.filter(condition, logs);
            List limited = filtered.stream().limit(10000L).collect(Collectors.toList());
            Logs result = new Logs();
            result.getLogs().addAll(limited);
            Logs logs2 = result;
            return logs2;
        }
        catch (KubernetesClientException e) {
            log.error("Failed to fetch logs from Kubernetes, {}", (Object)e.getMessage(), (Object)e);
            return new Logs().setErrorReason(e.getMessage() + ": " + e.getCode());
        }
    }

    private List<Log> filter(OndemandLogQueryCondition request, List<InternalLog> logs) {
        Duration duration = new Duration();
        duration.setStart(request.getDuration().getStart());
        duration.setEnd(request.getDuration().getEnd());
        duration.setStep(request.getDuration().getStep());
        long since = duration.getStartTimestamp() / 1000L;
        long to = duration.getEndTimestamp() / 1000L;
        List<String> inclusions = request.getKeywordsOfContent();
        com.google.common.base.Predicate inclusivePredicate = l -> inclusions.isEmpty() || inclusions.stream().anyMatch(k -> l.getContent().matches((String)k));
        List<String> exclusions = request.getExcludingKeywordsOfContent();
        com.google.common.base.Predicate exclusivePredicate = l -> exclusions.isEmpty() || exclusions.stream().noneMatch(k -> l.getContent().matches((String)k));
        return logs.stream().map(LogAdapter::new).map(LogAdapter::adapt).filter((Predicate<Log>)inclusivePredicate).filter((Predicate<Log>)exclusivePredicate).filter(it -> it.getTimestamp() >= since).filter(it -> it.getTimestamp() <= to).sorted(Comparator.comparing(Log::getTimestamp)).collect(Collectors.toList());
    }

    @Generated
    public OndemandLogQuery(MetadataQueryV2 metadataQuery) {
        this.metadataQuery = metadataQuery;
    }
}

