/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.MultipartRemovalStrategy;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.annotation.AnnotatedService;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.netty.channel.EventLoopGroup;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

final class DefaultServiceConfigSetters
implements ServiceConfigSetters<DefaultServiceConfigSetters> {
    @Nullable
    private String defaultServiceName;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private Function<? super HttpService, ? extends HttpService> decorator;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private BlockingTaskExecutor blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Long requestAutoAbortDelayMillis;
    @Nullable
    private Path multipartUploadsLocation;
    @Nullable
    private MultipartRemovalStrategy multipartRemovalStrategy;
    @Nullable
    private EventLoopGroup serviceWorkerGroup;
    @Nullable
    private ServiceErrorHandler serviceErrorHandler;
    private Supplier<? extends AutoCloseable> contextHook = RequestContextUtil.NOOP_CONTEXT_HOOK;
    private final List<ShutdownSupport> shutdownSupports = new ArrayList<ShutdownSupport>();
    private final HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
    @Nullable
    private Function<? super RoutingContext, ? extends RequestId> requestIdGenerator;

    DefaultServiceConfigSetters() {
    }

    @Override
    public DefaultServiceConfigSetters requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    @Override
    public DefaultServiceConfigSetters requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    @Override
    public DefaultServiceConfigSetters accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    @Override
    public DefaultServiceConfigSetters accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.accessLogWriter = this.accessLogWriter != null ? this.accessLogWriter.andThen(accessLogWriter) : accessLogWriter;
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(accessLogWriter));
        }
        return this;
    }

    @Override
    public DefaultServiceConfigSetters decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        this.decorator = this.decorator != null ? this.decorator.andThen(decorator) : decorator;
        return this;
    }

    Function<? super HttpService, ? extends HttpService> decorator() {
        if (this.decorator == null) {
            return Function.identity();
        }
        return this.decorator;
    }

    @Override
    @SafeVarargs
    public final DefaultServiceConfigSetters decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        return this.decorators(ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    @Override
    public DefaultServiceConfigSetters decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(decorators, "decorators");
        for (Function<? super HttpService, ? extends HttpService> function : decorators) {
            Objects.requireNonNull(function, "decorators contains null.");
            this.decorator((Function)function);
        }
        return this;
    }

    @Override
    public DefaultServiceConfigSetters defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = ServiceNaming.of(defaultServiceName);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceName = null;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        return this.blockingTaskExecutor(BlockingTaskExecutor.of(blockingTaskExecutor), shutdownOnStop);
    }

    @Override
    public DefaultServiceConfigSetters blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of(blockingTaskExecutor));
        }
        return this;
    }

    @Override
    public DefaultServiceConfigSetters blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public DefaultServiceConfigSetters successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @Override
    public DefaultServiceConfigSetters requestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
        return this;
    }

    @Override
    public DefaultServiceConfigSetters multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters multipartRemovalStrategy(MultipartRemovalStrategy removalStrategy) {
        this.multipartRemovalStrategy = Objects.requireNonNull(removalStrategy, "removalStrategy");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.serviceWorkerGroup = Objects.requireNonNull(serviceWorkerGroup, "serviceWorkerGroup");
        if (shutdownOnStop) {
            this.shutdownSupports.add(ShutdownSupport.of((ExecutorService)serviceWorkerGroup));
        }
        return this;
    }

    @Override
    public DefaultServiceConfigSetters serviceWorkerGroup(int numThreads) {
        EventLoopGroup workerGroup = EventLoopGroups.newEventLoopGroup(numThreads);
        return this.serviceWorkerGroup(workerGroup, true);
    }

    @Override
    public DefaultServiceConfigSetters requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.requestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        return this;
    }

    @Override
    public DefaultServiceConfigSetters addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.addObject(name, value);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.addObject(defaultHeaders);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        VirtualHostBuilder.ensureNoPseudoHeader(name);
        this.defaultHeaders.setObject(name, value);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        VirtualHostBuilder.ensureNoPseudoHeader(defaultHeaders);
        this.defaultHeaders.setObject(defaultHeaders);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters errorHandler(ServiceErrorHandler serviceErrorHandler) {
        Objects.requireNonNull(serviceErrorHandler, "serviceErrorHandler");
        this.serviceErrorHandler = this.serviceErrorHandler == null ? serviceErrorHandler : this.serviceErrorHandler.orElse(serviceErrorHandler);
        return this;
    }

    @Override
    public DefaultServiceConfigSetters contextHook(Supplier<? extends AutoCloseable> contextHook) {
        Objects.requireNonNull(contextHook, "contextHook");
        this.contextHook = RequestContextUtil.mergeHooks(this.contextHook, contextHook);
        return this;
    }

    ServiceConfigBuilder toServiceConfigBuilder(Route route, String contextPath, HttpService service) {
        String serviceName;
        ServiceConfigBuilder serviceConfigBuilder = new ServiceConfigBuilder(route, contextPath, service);
        AnnotatedService annotatedService = this.defaultServiceNaming == null || this.defaultLogName == null ? service.as(AnnotatedService.class) : null;
        if (this.defaultServiceName != null) {
            serviceConfigBuilder.defaultServiceName(this.defaultServiceName);
        } else if (this.defaultServiceNaming != null) {
            serviceConfigBuilder.defaultServiceNaming(this.defaultServiceNaming);
        } else if (annotatedService != null && (serviceName = annotatedService.name()) != null) {
            serviceConfigBuilder.defaultServiceName(serviceName);
        }
        if (this.defaultLogName != null) {
            serviceConfigBuilder.defaultLogName(this.defaultLogName);
        } else if (annotatedService != null) {
            serviceConfigBuilder.defaultLogName(annotatedService.methodName());
        }
        if (this.requestTimeoutMillis != null) {
            serviceConfigBuilder.requestTimeoutMillis(this.requestTimeoutMillis);
        }
        if (this.maxRequestLength != null) {
            serviceConfigBuilder.maxRequestLength(this.maxRequestLength);
        }
        if (this.verboseResponses != null) {
            serviceConfigBuilder.verboseResponses(this.verboseResponses);
        }
        if (this.accessLogWriter != null) {
            serviceConfigBuilder.accessLogWriter(this.accessLogWriter, false);
        }
        if (this.blockingTaskExecutor != null) {
            serviceConfigBuilder.blockingTaskExecutor(this.blockingTaskExecutor, false);
        }
        if (this.successFunction != null) {
            serviceConfigBuilder.successFunction(this.successFunction);
        }
        if (this.requestAutoAbortDelayMillis != null) {
            serviceConfigBuilder.requestAutoAbortDelayMillis(this.requestAutoAbortDelayMillis);
        }
        if (this.multipartUploadsLocation != null) {
            serviceConfigBuilder.multipartUploadsLocation(this.multipartUploadsLocation);
        }
        if (this.multipartRemovalStrategy != null) {
            serviceConfigBuilder.multipartRemovalStrategy(this.multipartRemovalStrategy);
        }
        if (this.serviceWorkerGroup != null) {
            serviceConfigBuilder.serviceWorkerGroup(this.serviceWorkerGroup, false);
        }
        if (this.requestIdGenerator != null) {
            serviceConfigBuilder.requestIdGenerator((Function)this.requestIdGenerator);
        }
        serviceConfigBuilder.shutdownSupports(this.shutdownSupports);
        if (!this.defaultHeaders.isEmpty()) {
            serviceConfigBuilder.defaultHeaders(this.defaultHeaders.build());
        }
        if (this.serviceErrorHandler != null) {
            serviceConfigBuilder.errorHandler(this.serviceErrorHandler);
        }
        serviceConfigBuilder.contextHook((Supplier)this.contextHook);
        return serviceConfigBuilder;
    }
}

