/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

public final class ByteBufsDecoderInput
implements StreamDecoderInput {
    private final ByteBufAllocator alloc;
    private final Queue<ByteBuf> queue;
    private int readableBytes;
    private boolean closed;

    public ByteBufsDecoderInput(ByteBufAllocator alloc) {
        this.alloc = alloc;
        this.queue = new ArrayDeque<ByteBuf>(4);
    }

    public boolean add(ByteBuf byteBuf) {
        int readableBytes = byteBuf.readableBytes();
        if (this.closed || readableBytes == 0) {
            byteBuf.release();
            return false;
        }
        this.queue.add(byteBuf);
        this.readableBytes += readableBytes;
        return true;
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public byte readByte() {
        ByteBuf buf = this.queue.peek();
        if (buf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = buf.readableBytes();
        byte value = buf.readByte();
        if (readableBytes == 1) {
            this.queue.remove();
            buf.release();
        }
        --this.readableBytes;
        return value;
    }

    @Override
    public int readUnsignedShort() {
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes >= 2) {
            int value = firstBuf.readUnsignedShort();
            if (readableBytes == 2) {
                this.queue.remove();
                firstBuf.release();
            }
            this.readableBytes -= 2;
            return value;
        }
        return StreamDecoderInput.super.readUnsignedShort();
    }

    @Override
    public int readInt() {
        int value;
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes >= 4) {
            value = firstBuf.readInt();
            if (readableBytes == 4) {
                this.queue.remove();
                firstBuf.release();
            }
        } else {
            value = this.readIntSlow();
        }
        this.readableBytes -= 4;
        return value;
    }

    private int readIntSlow() {
        int value = 0;
        int remaining = 4;
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            ByteBuf buf = (ByteBuf)it.next();
            int readableBytes = buf.readableBytes();
            int readSize = Math.min(remaining, readableBytes);
            value <<= 8 * readSize;
            switch (readSize) {
                case 1: {
                    value |= buf.readUnsignedByte();
                    break;
                }
                case 2: {
                    value |= buf.readUnsignedShort();
                    break;
                }
                case 3: {
                    value |= buf.readUnsignedMedium();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (readSize == readableBytes) {
                it.remove();
                buf.release();
            }
            if ((remaining -= readSize) != 0) continue;
            return value;
        }
        throw ByteBufsDecoderInput.newEndOfInputException();
    }

    @Override
    public long readLong() {
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes >= 8) {
            long value = firstBuf.readLong();
            if (readableBytes == 8) {
                this.queue.remove();
                firstBuf.release();
            }
            this.readableBytes -= 8;
            return value;
        }
        return (long)this.readInt() << 32 | (long)this.readInt();
    }

    @Override
    public ByteBuf readBytes(int length) {
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        Preconditions.checkArgument(length > 0, "length %s (expected: length > 0)", length);
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        ByteBuf byteBuf = readableBytes == length ? this.queue.remove() : (readableBytes > length ? firstBuf.readRetainedSlice(length) : this.readBytesSlow(length));
        this.readableBytes -= length;
        return byteBuf;
    }

    @Override
    public void readBytes(byte[] dst) {
        int length = dst.length;
        if (length == 0) {
            return;
        }
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes == length) {
            this.queue.remove().readBytes(dst).release();
        } else if (readableBytes > length) {
            firstBuf.readBytes(dst, 0, length);
        } else {
            this.readBytesSlow(dst);
        }
        this.readableBytes -= length;
    }

    private ByteBuf readBytesSlow(int length) {
        ByteBuf value = this.alloc.buffer(length);
        int remaining = length;
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            ByteBuf buf = (ByteBuf)it.next();
            int readableBytes = buf.readableBytes();
            assert (readableBytes > 0) : buf;
            int readSize = Math.min(remaining, readableBytes);
            value.writeBytes(buf, readSize);
            if (readableBytes == readSize) {
                it.remove();
                buf.release();
            }
            if ((remaining -= readSize) != 0) continue;
            return value;
        }
        value.release();
        throw ByteBufsDecoderInput.newEndOfInputException();
    }

    private void readBytesSlow(byte[] dst) {
        int remaining = dst.length;
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            ByteBuf buf = (ByteBuf)it.next();
            int readableBytes = buf.readableBytes();
            assert (readableBytes > 0) : buf;
            int readSize = Math.min(remaining, readableBytes);
            buf.readBytes(dst, dst.length - remaining, readSize);
            if (readableBytes == readSize) {
                it.remove();
                buf.release();
            }
            if ((remaining -= readSize) != 0) continue;
            return;
        }
        throw ByteBufsDecoderInput.newEndOfInputException();
    }

    @Override
    public byte getByte(int index) {
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes > index) {
            return firstBuf.getByte(firstBuf.readerIndex() + index);
        }
        return this.getByteSlow(index - readableBytes);
    }

    private byte getByteSlow(int remaining) {
        Iterator it = this.queue.iterator();
        it.next();
        while (it.hasNext()) {
            ByteBuf buf = (ByteBuf)it.next();
            int readableBytes = buf.readableBytes();
            if (readableBytes > remaining) {
                return buf.getByte(buf.readerIndex() + remaining);
            }
            remaining -= readableBytes;
        }
        throw ByteBufsDecoderInput.newEndOfInputException();
    }

    @Override
    public void skipBytes(int length) {
        if (length == 0) {
            return;
        }
        ByteBuf firstBuf = this.queue.peek();
        if (firstBuf == null) {
            throw ByteBufsDecoderInput.newEndOfInputException();
        }
        int readableBytes = firstBuf.readableBytes();
        if (readableBytes > length) {
            firstBuf.skipBytes(length);
        } else {
            this.skipBytesSlow(length - readableBytes);
        }
        this.readableBytes -= length;
    }

    private void skipBytesSlow(int remaining) {
        this.queue.remove().release();
        if (remaining <= 0) {
            return;
        }
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            ByteBuf buf = (ByteBuf)it.next();
            int readableBytes = buf.readableBytes();
            if (readableBytes > remaining) {
                buf.skipBytes(remaining);
                return;
            }
            buf.release();
            it.remove();
            if ((remaining -= readableBytes) != 0) continue;
            return;
        }
        throw ByteBufsDecoderInput.newEndOfInputException();
    }

    private static IllegalStateException newEndOfInputException() {
        return new IllegalStateException("end of deframer input");
    }

    @Override
    public void close() {
        ByteBuf buf;
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.readableBytes = 0;
        while ((buf = this.queue.poll()) != null) {
            buf.release();
        }
    }
}

