/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.encoding;

import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import com.aayushatharva.brotli4j.encoder.Encoder;
import com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import com.linecorp.armeria.internal.common.encoding.SnappyFramedOutputStream;
import com.linecorp.armeria.internal.common.encoding.StreamEncoderFactory;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.compression.Brotli;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public enum StreamEncoderFactories implements StreamEncoderFactory
{
    BROTLI{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.brotli().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            try {
                return new BrotliOutputStream((OutputStream)os, BROTLI_PARAMETERS);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing brotli header. This should not happen with byte arrays.", e);
            }
        }
    }
    ,
    GZIP{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.gzip().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            try {
                return new GZIPOutputStream((OutputStream)os, true);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing gzip header. This should not happen with byte arrays.", e);
            }
        }
    }
    ,
    DEFLATE{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.deflate().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            return new DeflaterOutputStream((OutputStream)os, true);
        }
    }
    ,
    SNAPPY{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.snappy().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            return new SnappyFramedOutputStream(os.buffer());
        }
    };

    private static final Encoder.Parameters BROTLI_PARAMETERS;

    static {
        Brotli.isAvailable();
        BROTLI_PARAMETERS = new Encoder.Parameters().setQuality(4);
    }
}

