/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.AbstractKeepAliveHandler;
import com.linecorp.armeria.internal.shaded.guava.base.Stopwatch;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2FrameWriter;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Http2KeepAliveHandler
extends AbstractKeepAliveHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http2KeepAliveHandler.class);
    @Nullable
    private final Stopwatch stopwatch = logger.isDebugEnabled() ? Stopwatch.createUnstarted() : null;
    private final Http2FrameWriter frameWriter;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final Channel channel;
    private long lastPingPayload;

    protected Http2KeepAliveHandler(Channel channel, Http2FrameWriter frameWriter, String name, Timer keepAliveTimer, long idleTimeoutMillis, long pingIntervalMillis, long maxConnectionAgeMillis, int maxNumRequestsPerConnection, boolean keepAliveOnPing) {
        super(channel, name, keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
        this.channel = Objects.requireNonNull(channel, "channel");
        this.frameWriter = Objects.requireNonNull(frameWriter, "frameWriter");
    }

    @Override
    public boolean isHttp2() {
        return true;
    }

    @Override
    protected final ChannelFuture writePing(ChannelHandlerContext ctx) {
        this.lastPingPayload = this.random.nextLong();
        ChannelFuture future = this.frameWriter.writePing(ctx, false, this.lastPingPayload, ctx.newPromise());
        ctx.flush();
        return future;
    }

    @Override
    public final void onPingAck(long data) {
        boolean isCancelled;
        long elapsed = this.getStopwatchElapsedInNanos();
        if (!this.isGoodPingAck(data)) {
            return;
        }
        this.onPing();
        Future<?> shutdownFuture = this.shutdownFuture();
        if (shutdownFuture != null && !(isCancelled = shutdownFuture.cancel(false))) {
            logger.debug("{} shutdownFuture cannot be cancelled because of late PING ACK", (Object)this.channel);
        }
        logger.debug("{} PING(ACK=1, DATA={}) received in {} ns", new Object[]{this.channel, this.lastPingPayload, elapsed});
    }

    @Override
    protected final boolean pingResetsPreviousPing() {
        return true;
    }

    private boolean isGoodPingAck(long data) {
        if (!this.isPendingPingAck()) {
            logger.debug("{} PING(ACK=1, DATA={}) ignored", (Object)this.channel, (Object)data);
            return false;
        }
        if (this.lastPingPayload != data) {
            logger.debug("{} Unexpected PING(ACK=1, DATA={}) received, but expecting PING(ACK=1, DATA={})", new Object[]{this.channel, data, this.lastPingPayload});
            return false;
        }
        return true;
    }

    final long lastPingPayload() {
        return this.lastPingPayload;
    }

    private long getStopwatchElapsedInNanos() {
        if (this.stopwatch == null) {
            return -1L;
        }
        return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
    }
}

