/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ContentPreviewer;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class LengthLimitingContentPreviewer
implements ContentPreviewer {
    private static final ByteBuf[] BYTE_BUFS = new ByteBuf[0];
    private final List<ByteBuf> bufferList = new ArrayList<ByteBuf>();
    private final int maxLength;
    private final int inflatedMaxLength;
    @Nullable
    private String produced;
    private int aggregatedLength;

    LengthLimitingContentPreviewer(int maxLength, @Nullable Charset charset) {
        this.maxLength = maxLength;
        if (maxLength > 0) {
            this.inflatedMaxLength = LengthLimitingContentPreviewer.inflateMaxLength(maxLength, charset);
        } else {
            this.inflatedMaxLength = 0;
            this.produced = "";
        }
    }

    private static int inflateMaxLength(int maxLength, @Nullable Charset charset) {
        if (charset == null) {
            return maxLength;
        }
        long maxBytesPerChar = (long)Math.ceil(CharsetUtil.encoder((Charset)charset).maxBytesPerChar());
        return Ints.saturatedCast(maxBytesPerChar * (long)maxLength);
    }

    @Override
    public final void onData(HttpData data) {
        int length;
        Objects.requireNonNull(data, "data");
        if (this.produced != null) {
            return;
        }
        if (!data.isEmpty() && (length = Math.min(this.inflatedMaxLength - this.aggregatedLength, data.length())) > 0) {
            this.bufferList.add(data.byteBuf(0, length, ByteBufAccessMode.RETAINED_DUPLICATE));
            this.aggregatedLength = IntMath.saturatedAdd(this.aggregatedLength, length);
            if (this.aggregatedLength >= this.inflatedMaxLength) {
                this.produce();
                return;
            }
        }
        if (data.isEndOfStream()) {
            this.produce();
        }
    }

    @Override
    public final String produce() {
        if (this.produced != null) {
            return this.produced;
        }
        try {
            String produced = this.produce(Unpooled.wrappedBuffer((ByteBuf[])this.bufferList.toArray(BYTE_BUFS)));
            this.produced = produced.length() > this.maxLength ? produced.substring(0, this.maxLength) : produced;
            String string = this.produced;
            return string;
        }
        finally {
            this.bufferList.forEach(ReferenceCountUtil::safeRelease);
            this.bufferList.clear();
        }
    }

    abstract String produce(ByteBuf var1);
}

