/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpChannelPool;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.endpoint.EmptyEndpointGroupException;
import com.linecorp.armeria.client.proxy.HAProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.IpAddressRejectedException;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ClientConnectionTimings;
import com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.DecodedHttpResponse;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.PooledChannel;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.util.IpAddrUtil;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;

final class HttpClientDelegate
implements HttpClient {
    private final HttpClientFactory factory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;

    HttpClientDelegate(HttpClientFactory factory, AddressResolverGroup<InetSocketAddress> addressResolverGroup) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.addressResolverGroup = Objects.requireNonNull(addressResolverGroup, "addressResolverGroup");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Throwable throwable = ClientPendingThrowableUtil.pendingThrowable(ctx);
        if (throwable != null) {
            return HttpClientDelegate.earlyFailedResponse(throwable, ctx);
        }
        if (req != ctx.request()) {
            return HttpClientDelegate.earlyFailedResponse(new IllegalStateException("ctx.request() does not match the actual request; did you forget to call ctx.updateRequest() in your decorator?"), ctx);
        }
        Endpoint endpoint = ctx.endpoint();
        if (endpoint == null) {
            return HttpClientDelegate.earlyFailedResponse(EmptyEndpointGroupException.get(ctx.endpointGroup()), ctx);
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        Endpoint endpointWithPort = endpoint.withDefaultPort(ctx.sessionProtocol());
        EventLoop eventLoop = ctx.eventLoop().withoutContext();
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        HttpClientDelegate.updateCancellationTask(ctx, req, res);
        try {
            this.resolveProxyConfig(protocol, endpoint, ctx, (proxyConfig, thrown) -> {
                if (thrown != null) {
                    HttpClientDelegate.earlyFailedResponse(thrown, ctx, res);
                } else {
                    assert (proxyConfig != null);
                    this.execute0(ctx, endpointWithPort, req, res, (ProxyConfig)proxyConfig);
                }
            });
        }
        catch (Throwable t) {
            return HttpClientDelegate.earlyFailedResponse(t, ctx);
        }
        return res;
    }

    private void execute0(ClientRequestContext ctx, Endpoint endpointWithPort, HttpRequest req, DecodedHttpResponse res, ProxyConfig proxyConfig) {
        Throwable cancellationCause = ctx.cancellationCause();
        if (cancellationCause != null) {
            HttpClientDelegate.earlyFailedResponse(cancellationCause, ctx, res);
            return;
        }
        ClientConnectionTimingsBuilder timingsBuilder = ClientConnectionTimings.builder();
        if (endpointWithPort.hasIpAddr() || proxyConfig.proxyType().isForwardProxy()) {
            this.acquireConnectionAndExecute(ctx, endpointWithPort, req, res, timingsBuilder, proxyConfig);
        } else {
            this.resolveAddress(endpointWithPort, ctx, (resolved, cause) -> {
                timingsBuilder.dnsResolutionEnd();
                if (cause == null) {
                    assert (resolved != null);
                    this.acquireConnectionAndExecute(ctx, (Endpoint)resolved, req, res, timingsBuilder, proxyConfig);
                } else {
                    HttpClientDelegate.earlyCancelRequest(cause, ctx, timingsBuilder);
                }
            });
        }
    }

    private static void updateCancellationTask(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        if (ctxExt == null) {
            return;
        }
        ctxExt.responseCancellationScheduler().updateTask(cause -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                UnprocessedRequestException ure = UnprocessedRequestException.of(cause);
                req.abort(ure);
                ctx.logBuilder().endRequest(ure);
                res.close(ure);
                ctx.logBuilder().endResponse(ure);
            }
        });
    }

    private void resolveAddress(Endpoint endpoint, ClientRequestContext ctx, BiConsumer<@Nullable Endpoint, @Nullable Throwable> onComplete) {
        assert (!endpoint.hasIpAddr() && endpoint.hasPort());
        Future resolveFuture = this.addressResolverGroup.getResolver((EventExecutor)ctx.eventLoop().withoutContext()).resolve((SocketAddress)endpoint.toSocketAddress(-1));
        if (resolveFuture.isSuccess()) {
            InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
            onComplete.accept(endpoint.withInetAddress(address), null);
        } else {
            resolveFuture.addListener(future -> {
                if (future.isSuccess()) {
                    InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
                    onComplete.accept(endpoint.withInetAddress(address), null);
                } else {
                    onComplete.accept(null, resolveFuture.cause());
                }
            });
        }
    }

    private void acquireConnectionAndExecute(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        InetSocketAddress remoteAddress = endpoint.toSocketAddress(-1);
        try {
            boolean isValidIpAddr = this.factory.options().ipAddressFilter().test(remoteAddress);
            if (!isValidIpAddr) {
                IpAddressRejectedException cause = new IpAddressRejectedException("Invalid IP address: " + remoteAddress + " (endpoint: " + endpoint + ')');
                HttpClientDelegate.earlyCancelRequest(cause, ctx, timingsBuilder);
                return;
            }
        }
        catch (Throwable t) {
            IllegalStateException cause = new IllegalStateException("Unexpected exception from " + this.factory.options().ipAddressFilter(), t);
            HttpClientDelegate.earlyCancelRequest(cause, ctx, timingsBuilder);
            return;
        }
        if (ctx.eventLoop().inEventLoop()) {
            this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig);
        } else {
            ctx.eventLoop().execute(() -> this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig));
        }
    }

    private void acquireConnectionAndExecute0(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        HttpChannelPool pool;
        HttpChannelPool.PoolKey key = new HttpChannelPool.PoolKey(endpoint, proxyConfig);
        try {
            pool = this.factory.pool(ctx.eventLoop().withoutContext());
        }
        catch (Throwable t) {
            HttpClientDelegate.earlyCancelRequest(t, ctx, timingsBuilder);
            return;
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        SerializationFormat serializationFormat = ctx.log().partial().serializationFormat();
        PooledChannel pooledChannel = pool.acquireNow(protocol, serializationFormat, key);
        if (pooledChannel != null) {
            HttpClientDelegate.logSession(ctx, pooledChannel, null);
            HttpClientDelegate.doExecute(pooledChannel, ctx, req, res);
        } else {
            pool.acquireLater(protocol, serializationFormat, key, timingsBuilder).handle((newPooledChannel, cause) -> {
                if (cause == null) {
                    HttpClientDelegate.logSession(ctx, newPooledChannel, timingsBuilder.build());
                    HttpClientDelegate.doExecute(newPooledChannel, ctx, req, res);
                } else {
                    HttpClientDelegate.earlyCancelRequest(cause, ctx, timingsBuilder);
                }
                return null;
            });
        }
    }

    private void resolveProxyConfig(SessionProtocol protocol, Endpoint endpoint, ClientRequestContext ctx, BiConsumer<@Nullable ProxyConfig, @Nullable Throwable> onComplete) {
        boolean needsDnsResolution;
        ProxyConfig unresolvedProxyConfig = this.factory.proxyConfigSelector().select(protocol, endpoint);
        Objects.requireNonNull(unresolvedProxyConfig, "unresolvedProxyConfig");
        ProxyConfig proxyConfig = HttpClientDelegate.maybeSetHAProxySourceAddress(unresolvedProxyConfig);
        InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
        boolean bl = needsDnsResolution = proxyAddress != null && !IpAddrUtil.isCreatedWithIpAddressOnly(proxyAddress);
        if (needsDnsResolution) {
            assert (proxyAddress != null);
            Future resolveFuture = this.addressResolverGroup.getResolver((EventExecutor)ctx.eventLoop().withoutContext()).resolve((SocketAddress)HttpClientDelegate.createUnresolvedAddressForRefreshing(proxyAddress));
            resolveFuture.addListener(future -> {
                if (future.isSuccess()) {
                    InetSocketAddress resolvedAddress = (InetSocketAddress)future.getNow();
                    ProxyConfig newProxyConfig = proxyConfig.withProxyAddress(resolvedAddress);
                    onComplete.accept(newProxyConfig, null);
                } else {
                    Throwable cause = future.cause();
                    onComplete.accept(null, cause);
                }
            });
        } else {
            onComplete.accept(proxyConfig, null);
        }
    }

    private static ProxyConfig maybeSetHAProxySourceAddress(ProxyConfig proxyConfig) {
        ProxiedAddresses serviceProxiedAddresses;
        if (proxyConfig.proxyType() != ProxyType.HAPROXY) {
            return proxyConfig;
        }
        if (((HAProxyConfig)proxyConfig).sourceAddress() != null) {
            return proxyConfig;
        }
        ServiceRequestContext sctx = ServiceRequestContext.currentOrNull();
        ProxiedAddresses proxiedAddresses = serviceProxiedAddresses = sctx == null ? null : sctx.proxiedAddresses();
        if (serviceProxiedAddresses != null) {
            InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
            assert (proxyAddress != null);
            return ProxyConfig.haproxy(proxyAddress, serviceProxiedAddresses.sourceAddress());
        }
        return proxyConfig;
    }

    private static void logSession(ClientRequestContext ctx, @Nullable PooledChannel pooledChannel, @Nullable ClientConnectionTimings connectionTimings) {
        if (pooledChannel != null) {
            Channel channel = pooledChannel.get();
            SessionProtocol actualProtocol = pooledChannel.protocol();
            ctx.logBuilder().session(channel, actualProtocol, connectionTimings);
        } else {
            ctx.logBuilder().session(null, ctx.sessionProtocol(), connectionTimings);
        }
    }

    private static HttpResponse earlyFailedResponse(Throwable t, ClientRequestContext ctx) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        ctx.cancel(cause);
        return HttpResponse.ofFailure(cause);
    }

    private static HttpResponse earlyFailedResponse(Throwable t, ClientRequestContext ctx, DecodedHttpResponse response) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        ctx.cancel(cause);
        response.close(cause);
        return response;
    }

    private static void earlyCancelRequest(Throwable t, ClientRequestContext ctx, ClientConnectionTimingsBuilder connectionTimings) {
        ctx.logBuilder().session(null, ctx.sessionProtocol(), connectionTimings.build());
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        ctx.cancel(cause);
    }

    private static void doExecute(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        Channel channel = pooledChannel.get();
        HttpSession session = HttpSession.get(channel);
        res.init(session.inboundTrafficController());
        session.invoke(pooledChannel, ctx, req, res);
    }

    private static InetSocketAddress createUnresolvedAddressForRefreshing(InetSocketAddress previousAddress) {
        return InetSocketAddress.createUnresolved(previousAddress.getHostString(), previousAddress.getPort());
    }
}

