/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.webapp;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ZipkinProxyService
extends AbstractHttpService {
    private final WebClient loadBalancingClient;

    public ZipkinProxyService(String[] zipkinServices) throws Exception {
        List endpoints = Stream.of(zipkinServices).map(URI::create).map(URI::getAuthority).map(Endpoint::parse).collect(Collectors.toList());
        this.loadBalancingClient = ZipkinProxyService.newLoadBalancingClient(EndpointGroup.of(EndpointSelectionStrategy.roundRobin(), endpoints));
    }

    private static WebClient newLoadBalancingClient(EndpointGroup zipkinGroup) {
        return ((WebClientBuilder)WebClient.builder(SessionProtocol.HTTP, zipkinGroup).decorator(LoggingClient.newDecorator())).build();
    }

    @Override
    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return this.loadBalancingClient.execute(req);
    }
}

