/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.ShuttingDownException;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.server.DefaultGracefulShutdown;
import com.linecorp.armeria.server.DefaultServerConfig;
import com.linecorp.armeria.server.GracefulShutdown;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
public final class GracefulShutdownBuilder {
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD = Duration.ZERO;
    private static final Duration DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = Duration.ZERO;
    private static final BiFunction<ServiceRequestContext, HttpRequest, Throwable> DEFAULT_ERROR_FUNCTION = (ctx, req) -> ShuttingDownException.get();
    static final GracefulShutdown DISABLED = GracefulShutdown.builder().build();
    private Duration quietPeriod = DEFAULT_GRACEFUL_SHUTDOWN_QUIET_PERIOD;
    private Duration timeout = DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
    private BiFunction<ServiceRequestContext, HttpRequest, Throwable> toException = DEFAULT_ERROR_FUNCTION;

    GracefulShutdownBuilder() {
    }

    public GracefulShutdownBuilder quietPeriod(Duration quietPeriod) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        this.quietPeriod = DefaultServerConfig.validateNonNegative(quietPeriod, "quietPeriod");
        return this;
    }

    public GracefulShutdownBuilder quietPeriodMillis(long quietPeriodMillis) {
        return this.quietPeriod(Duration.ofMillis(quietPeriodMillis));
    }

    public GracefulShutdownBuilder timeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.timeout = DefaultServerConfig.validateNonNegative(timeout, "timeout");
        return this;
    }

    public GracefulShutdownBuilder timeoutMillis(long timeoutMillis) {
        return this.timeout(Duration.ofMillis(timeoutMillis));
    }

    public GracefulShutdownBuilder toExceptionFunction(BiFunction<? super ServiceRequestContext, ? super HttpRequest, ? extends Throwable> toException) {
        Objects.requireNonNull(toException, "toException");
        this.toException = toException;
        return this;
    }

    private static void validateGreaterThanOrEqual(Duration larger, String largerFieldName, Duration smaller, String smallerFieldName) {
        if (larger.compareTo(smaller) < 0) {
            throw new IllegalArgumentException(largerFieldName + " must be greater than or equal to " + smallerFieldName);
        }
    }

    public GracefulShutdown build() {
        GracefulShutdownBuilder.validateGreaterThanOrEqual(this.timeout, "timeout", this.quietPeriod, "quietPeriod");
        return new DefaultGracefulShutdown(this.quietPeriod, this.timeout, this.toException);
    }
}

