/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.reflections.util;

import com.linecorp.armeria.internal.shaded.reflections.Reflections;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;

public abstract class ClasspathHelper {
    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader contextClassLoader = ClasspathHelper.contextClassLoader();
        ClassLoader staticClassLoader = ClasspathHelper.staticClassLoader();
        if (contextClassLoader != null) {
            if (staticClassLoader != null && contextClassLoader != staticClassLoader) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[2];
                classLoaderArray2[0] = contextClassLoader;
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[1] = staticClassLoader;
            } else {
                ClassLoader[] classLoaderArray3 = new ClassLoader[1];
                classLoaderArray = classLoaderArray3;
                classLoaderArray3[0] = contextClassLoader;
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return classLoaderArray;
    }

    public static Collection<URL> forPackage(String name, ClassLoader ... classLoaders) {
        return ClasspathHelper.forResource(ClasspathHelper.resourceName(name), classLoaders);
    }

    public static Collection<URL> forResource(String resourceName, ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader classLoader : loaders = ClasspathHelper.classLoaders(classLoaders)) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(resourceName);
                    if (index != -1) {
                        result.add(new URL(url, url.toExternalForm().substring(0, index)));
                        continue;
                    }
                    result.add(url);
                }
            }
            catch (IOException e) {
                if (Reflections.log == null) continue;
                Reflections.log.error("error getting resources for " + resourceName, e);
            }
        }
        return ClasspathHelper.distinctUrls(result);
    }

    private static String resourceName(String name) {
        if (name != null) {
            String resourceName = name.replace(".", "/");
            if ((resourceName = resourceName.replace("\\", "/")).startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return resourceName;
        }
        return null;
    }

    private static Collection<URL> distinctUrls(Collection<URL> urls) {
        LinkedHashMap<String, URL> distinct = new LinkedHashMap<String, URL>(urls.size());
        for (URL url : urls) {
            distinct.put(url.toExternalForm(), url);
        }
        return distinct.values();
    }
}

