/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public final class HttpTimestampSupplier {
    private static final HttpTimestampSupplier INSTANCE = new HttpTimestampSupplier();
    private static final long NANOS_IN_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final Supplier<Instant> instantSupplier;
    private final LongSupplier nanoTimeSupplier;
    private String timestamp = "";
    private long nextUpdateNanos;

    public static String currentTime() {
        return INSTANCE.currentTimestamp();
    }

    private HttpTimestampSupplier() {
        this(Instant::now, System::nanoTime);
    }

    HttpTimestampSupplier(Supplier<Instant> instantSupplier, LongSupplier nanoTimeSupplier) {
        this.instantSupplier = Objects.requireNonNull(instantSupplier, "instantSupplier");
        this.nanoTimeSupplier = Objects.requireNonNull(nanoTimeSupplier, "nanoTimeSupplier");
        this.nextUpdateNanos = nanoTimeSupplier.getAsLong();
    }

    String currentTimestamp() {
        long currentTimeNanos = this.nanoTimeSupplier.getAsLong();
        if (this.nextUpdateNanos - currentTimeNanos > 0L) {
            return this.timestamp;
        }
        Instant now = this.instantSupplier.get();
        this.nextUpdateNanos = currentTimeNanos - (long)now.getNano() + NANOS_IN_SECOND;
        this.timestamp = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(now, ZoneOffset.UTC));
        return this.timestamp;
    }
}

