/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class RateLimitingSampler<T>
implements Sampler<T> {
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOS_PER_DECISECOND = NANOS_PER_SECOND / 10L;
    final MaxFunction maxFunction;
    private final AtomicInteger usage = new AtomicInteger();
    private final AtomicLong nextReset;
    private final int samplesPerSecond;

    static <T> Sampler<T> create(int samplesPerSecond) {
        Preconditions.checkArgument(samplesPerSecond >= 0, "samplesPerSecond: %s (expected: >= 0)", samplesPerSecond);
        if (samplesPerSecond == 0) {
            return Sampler.never();
        }
        return new RateLimitingSampler<T>(samplesPerSecond);
    }

    RateLimitingSampler(int samplesPerSecond) {
        this.maxFunction = samplesPerSecond < 10 ? new LessThan10(samplesPerSecond) : new AtLeast10(samplesPerSecond);
        long now = System.nanoTime();
        this.nextReset = new AtomicLong(now + NANOS_PER_SECOND);
        this.samplesPerSecond = samplesPerSecond;
    }

    @Override
    public boolean isSampled(Object ignored) {
        int next;
        int prev;
        long updateAt;
        long now = System.nanoTime();
        long nanosUntilReset = -(now - (updateAt = this.nextReset.get()));
        if (nanosUntilReset <= 0L) {
            if (this.nextReset.compareAndSet(updateAt, now + NANOS_PER_SECOND)) {
                this.usage.set(0);
            }
            return this.isSampled(ignored);
        }
        int max = this.maxFunction.max(nanosUntilReset);
        do {
            if ((next = (prev = this.usage.get()) + 1) <= max) continue;
            return false;
        } while (!this.usage.compareAndSet(prev, next));
        return true;
    }

    public String toString() {
        return "rate-limiting=" + this.samplesPerSecond;
    }

    static final class LessThan10
    extends MaxFunction {
        final int samplesPerSecond;

        LessThan10(int samplesPerSecond) {
            this.samplesPerSecond = samplesPerSecond;
        }

        @Override
        int max(long nanosUntilResetIgnored) {
            return this.samplesPerSecond;
        }
    }

    private static final class AtLeast10
    extends MaxFunction {
        final int[] max;

        AtLeast10(int samplesPerSecond) {
            int samplesPerDecisecond = samplesPerSecond / 10;
            int remainder = samplesPerSecond % 10;
            this.max = new int[10];
            this.max[0] = samplesPerDecisecond + remainder;
            for (int i = 1; i < 10; ++i) {
                this.max[i] = this.max[i - 1] + samplesPerDecisecond;
            }
        }

        @Override
        int max(long nanosUntilReset) {
            if (nanosUntilReset > NANOS_PER_SECOND - NANOS_PER_DECISECOND) {
                return this.max[0];
            }
            if (nanosUntilReset < NANOS_PER_DECISECOND) {
                return this.max[9];
            }
            int decisecondsUntilReset = (int)(nanosUntilReset / NANOS_PER_DECISECOND);
            return this.max[10 - decisecondsUntilReset];
        }
    }

    private static abstract class MaxFunction {
        private MaxFunction() {
        }

        abstract int max(long var1);
    }
}

