/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.common.metric.CloseableMeterBinder;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractCloseableMeterBinder
implements CloseableMeterBinder {
    private final List<Runnable> closingTasks = new ArrayList<Runnable>();
    private final ReentrantShortLock lock = new ReentrantShortLock();

    AbstractCloseableMeterBinder() {
    }

    protected final void addClosingTask(Runnable closingTask) {
        this.lock.lock();
        try {
            this.closingTasks.add(closingTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            for (Runnable task : this.closingTasks) {
                task.run();
            }
            this.closingTasks.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

