/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.AbstractBackoff;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.BackoffWrapper;
import com.linecorp.armeria.client.retry.RandomBackoff;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

final class JitterAddingBackoff
extends BackoffWrapper {
    private final Supplier<Random> randomSupplier;
    private final double minJitterRate;
    private final double maxJitterRate;

    JitterAddingBackoff(Backoff delegate, double minJitterRate, double maxJitterRate, Supplier<Random> randomSupplier) {
        super(delegate);
        this.randomSupplier = Objects.requireNonNull(randomSupplier, "randomSupplier");
        Preconditions.checkArgument(-1.0 <= minJitterRate && minJitterRate <= 1.0, "minJitterRate: %s (expected: >= -1.0 and <= 1.0)", (Object)minJitterRate);
        Preconditions.checkArgument(-1.0 <= maxJitterRate && maxJitterRate <= 1.0, "maxJitterRate: %s (expected: >= -1.0 and <= 1.0)", (Object)maxJitterRate);
        Preconditions.checkArgument(minJitterRate <= maxJitterRate, "maxJitterRate: %s needs to be greater than or equal to minJitterRate: %s", (Object)maxJitterRate, (Object)minJitterRate);
        this.minJitterRate = minJitterRate;
        this.maxJitterRate = maxJitterRate;
    }

    @Override
    public long nextDelayMillis(int numAttemptsSoFar) {
        AbstractBackoff.validateNumAttemptsSoFar(numAttemptsSoFar);
        long nextDelayMillis = ((Backoff)this.unwrap()).nextDelayMillis(numAttemptsSoFar);
        if (nextDelayMillis < 0L) {
            return nextDelayMillis;
        }
        long minJitter = (long)((double)nextDelayMillis * (1.0 + this.minJitterRate));
        long maxJitter = (long)((double)nextDelayMillis * (1.0 + this.maxJitterRate));
        long bound = maxJitter - minJitter + 1L;
        long millis = RandomBackoff.nextLong(this.randomSupplier.get(), bound);
        return Math.max(0L, LongMath.saturatedAdd(minJitter, millis));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.unwrap()).add("minJitterRate", this.minJitterRate).add("maxJitterRate", this.maxJitterRate).toString();
    }
}

