/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpPreprocessor;
import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.RpcPreprocessor;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ClientBuilder
extends AbstractClientOptionsBuilder {
    @Nullable
    private final URI uri;
    @Nullable
    private final EndpointGroup endpointGroup;
    @Nullable
    private final String path;
    private final Scheme scheme;

    ClientBuilder(URI uri) {
        Preconditions.checkArgument(uri.getScheme() != null, "uri must have scheme: %s", (Object)uri);
        Preconditions.checkArgument(uri.getRawAuthority() != null, "uri must have authority: %s", (Object)uri);
        this.uri = uri;
        this.endpointGroup = null;
        this.path = null;
        this.scheme = Scheme.parse(uri.getScheme());
    }

    ClientBuilder(Scheme scheme, EndpointGroup endpointGroup, @Nullable String path) {
        if (path != null) {
            Preconditions.checkArgument(path.startsWith("/"), "path: %s (expected: an absolute path starting with '/')", (Object)path);
        }
        this.uri = null;
        this.endpointGroup = endpointGroup;
        this.path = path;
        this.scheme = scheme;
    }

    public <T> T build(Class<T> clientType) {
        Object client;
        Objects.requireNonNull(clientType, "clientType");
        ClientOptions options = this.buildOptions();
        ClientFactory factory = options.factory();
        if (this.uri != null) {
            client = factory.newClient(ClientBuilderParams.of(this.uri, clientType, options));
        } else {
            assert (this.endpointGroup != null);
            client = factory.newClient(ClientBuilderParams.of(this.scheme, this.endpointGroup, this.path, clientType, options));
        }
        Object cast = client;
        return (T)cast;
    }

    @Override
    public ClientBuilder options(ClientOptions options) {
        return (ClientBuilder)super.options(options);
    }

    @Override
    public ClientBuilder options(ClientOptionValue<?> ... options) {
        return (ClientBuilder)super.options(options);
    }

    @Override
    public ClientBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (ClientBuilder)super.options(options);
    }

    @Override
    public <T> ClientBuilder option(ClientOption<T> option, T value) {
        return (ClientBuilder)super.option(option, value);
    }

    @Override
    public <T> ClientBuilder option(ClientOptionValue<T> optionValue) {
        return (ClientBuilder)super.option(optionValue);
    }

    @Override
    public ClientBuilder factory(ClientFactory factory) {
        return (ClientBuilder)super.factory(factory);
    }

    @Override
    public ClientBuilder writeTimeout(Duration writeTimeout) {
        return (ClientBuilder)super.writeTimeout(writeTimeout);
    }

    @Override
    public ClientBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (ClientBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    @Override
    public ClientBuilder responseTimeout(Duration responseTimeout) {
        return (ClientBuilder)super.responseTimeout(responseTimeout);
    }

    @Override
    public ClientBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (ClientBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    @Override
    public ClientBuilder maxResponseLength(long maxResponseLength) {
        return (ClientBuilder)super.maxResponseLength(maxResponseLength);
    }

    @Override
    public ClientBuilder requestAutoAbortDelay(Duration delay) {
        return (ClientBuilder)super.requestAutoAbortDelay(delay);
    }

    @Override
    public ClientBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (ClientBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    @Override
    public ClientBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (ClientBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    @Override
    @UnstableApi
    public ClientBuilder successFunction(SuccessFunction successFunction) {
        return (ClientBuilder)super.successFunction(successFunction);
    }

    @Override
    public ClientBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (ClientBuilder)super.endpointRemapper(endpointRemapper);
    }

    @Override
    public ClientBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (ClientBuilder)super.decorator(decorator);
    }

    @Override
    public ClientBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (ClientBuilder)super.decorator(decorator);
    }

    @Override
    public ClientBuilder clearDecorators() {
        return (ClientBuilder)super.clearDecorators();
    }

    @Override
    public ClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (ClientBuilder)super.rpcDecorator(decorator);
    }

    @Override
    public ClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (ClientBuilder)super.rpcDecorator(decorator);
    }

    @Override
    public ClientBuilder addHeader(CharSequence name, Object value) {
        return (ClientBuilder)super.addHeader(name, value);
    }

    @Override
    public ClientBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ClientBuilder)super.addHeaders(headers);
    }

    @Override
    public ClientBuilder setHeader(CharSequence name, Object value) {
        return (ClientBuilder)super.setHeader(name, value);
    }

    @Override
    public ClientBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ClientBuilder)super.setHeaders(headers);
    }

    @Override
    public ClientBuilder auth(BasicToken token) {
        return (ClientBuilder)super.auth(token);
    }

    @Override
    public ClientBuilder auth(OAuth1aToken token) {
        return (ClientBuilder)super.auth(token);
    }

    @Override
    public ClientBuilder auth(OAuth2Token token) {
        return (ClientBuilder)super.auth(token);
    }

    @Override
    public ClientBuilder auth(AuthToken token) {
        return (ClientBuilder)super.auth(token);
    }

    @Override
    public ClientBuilder followRedirects() {
        return (ClientBuilder)super.followRedirects();
    }

    @Override
    public ClientBuilder followRedirects(RedirectConfig redirectConfig) {
        return (ClientBuilder)super.followRedirects(redirectConfig);
    }

    @Override
    public ClientBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (ClientBuilder)super.contextCustomizer(contextCustomizer);
    }

    @Override
    public ClientBuilder contextHook(Supplier<? extends AutoCloseable> contextHook) {
        return (ClientBuilder)super.contextHook(contextHook);
    }

    @Override
    public ClientBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        return (ClientBuilder)super.responseTimeoutMode(responseTimeoutMode);
    }

    @Override
    public ClientBuilder preprocessor(HttpPreprocessor decorator) {
        return (ClientBuilder)super.preprocessor(decorator);
    }

    @Override
    public ClientBuilder rpcPreprocessor(RpcPreprocessor decorator) {
        return (ClientBuilder)super.rpcPreprocessor(decorator);
    }
}

