/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.type;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.jfr.type.Frame;

public class FrameTree {
    private final String frame;
    private final long total;
    private final long self;
    private List<FrameTree> children;

    public FrameTree(Frame frame, String[] key2frame) {
        int titleIndex = frame.getTitleIndex();
        this.frame = key2frame[titleIndex];
        this.total = frame.total;
        this.self = frame.self;
    }

    public static FrameTree buildTree(Frame frame, String[] key2frame) {
        if (frame == null) {
            return null;
        }
        FrameTree frameTree = new FrameTree(frame, key2frame);
        if (!frame.isEmpty()) {
            frameTree.children = new ArrayList<FrameTree>(frame.size());
            for (Frame childFrame : frame.values()) {
                FrameTree childFrameTree = FrameTree.buildTree(childFrame, key2frame);
                frameTree.children.add(childFrameTree);
            }
        }
        return frameTree;
    }

    @Generated
    public String getFrame() {
        return this.frame;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public long getSelf() {
        return this.self;
    }

    @Generated
    public List<FrameTree> getChildren() {
        return this.children;
    }
}

