/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.parser;

import java.util.List;
import org.apache.skywalking.oap.server.library.jfr.type.Frame;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.Index;

public class JFRMergeBuilder {
    private final Index<String> cpool = new Index<String>(String.class, "");
    private final Frame root = new Frame(0, 3);

    public JFRMergeBuilder merge(List<FrameTree> trees) {
        if (trees == null || trees.isEmpty()) {
            return this;
        }
        for (FrameTree tree : trees) {
            this.merge0(this.root, tree);
        }
        return this;
    }

    public JFRMergeBuilder merge(FrameTree tree) {
        this.merge0(this.root, tree);
        return this;
    }

    public void merge0(Frame frame, FrameTree tree) {
        if (tree == null) {
            return;
        }
        if (tree.getChildren() != null) {
            for (FrameTree children : tree.getChildren()) {
                Frame child = this.addChild(frame, children.getFrame());
                this.merge0(child, children);
            }
        }
        frame.setTotal(frame.getTotal() + tree.getTotal());
        frame.setSelf(frame.getSelf() + tree.getSelf());
    }

    private Frame addChild(Frame frame, String title) {
        int titleIndex = this.cpool.index(title);
        return frame.getChild(titleIndex, (byte)0);
    }

    public FrameTree build() {
        String[] keys = this.cpool.keys();
        return FrameTree.buildTree(this.root, keys);
    }
}

