/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.BaseClient;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.monitoring.ClientEventCallback;
import com.orbitz.consul.option.QueryOptions;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.QueryMap;

public class StatusClient
extends BaseClient {
    private static String CLIENT_NAME = "status";
    private final Api api;

    StatusClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public String getLeader() {
        return this.getLeader(QueryOptions.BLANK);
    }

    public String getLeader(QueryOptions queryOptions) {
        return this.http.extract(this.api.getLeader(queryOptions.toQuery()), new Integer[0]).replace("\"", "").trim();
    }

    public List<String> getPeers() {
        return this.getPeers(QueryOptions.BLANK);
    }

    public List<String> getPeers(QueryOptions queryOptions) {
        return this.http.extract(this.api.getPeers(queryOptions.toQuery()), new Integer[0]);
    }

    static interface Api {
        @GET(value="status/leader")
        public Call<String> getLeader(@QueryMap Map<String, Object> var1);

        @GET(value="status/peers")
        public Call<List<String>> getPeers(@QueryMap Map<String, Object> var1);
    }
}

