/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.handler.grpc;

import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserErrorLog;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserPerfData;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserPerfServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserResourcePerfData;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserWebInteractionsPerfData;
import org.apache.skywalking.apm.network.language.agent.v3.BrowserWebVitalsPerfData;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.ErrorLogParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataAnalyzer;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.PerfDataParserListenerManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserResourcePerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserWebInteractionPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserWebVitalsPerfDataDecorator;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPerfServiceHandler
extends BrowserPerfServiceGrpc.BrowserPerfServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrowserPerfServiceHandler.class);
    private final ModuleManager moduleManager;
    private final BrowserServiceModuleConfig config;
    private final PerfDataParserListenerManager perfDataListenerManager;
    private final ErrorLogParserListenerManager errorLogListenerManager;
    private final HistogramMetrics perfHistogram;
    private final CounterMetrics perfErrorCounter;
    private final HistogramMetrics errorLogHistogram;
    private final CounterMetrics logErrorCounter;

    public BrowserPerfServiceHandler(ModuleManager moduleManager, BrowserServiceModuleConfig config, PerfDataParserListenerManager perfDataListenerManager, ErrorLogParserListenerManager errorLogListenerManager) {
        this.moduleManager = moduleManager;
        this.config = config;
        this.perfDataListenerManager = perfDataListenerManager;
        this.errorLogListenerManager = errorLogListenerManager;
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.perfHistogram = metricsCreator.createHistogramMetric("browser_perf_data_in_latency", "The process latency of browser performance data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.perfErrorCounter = metricsCreator.createCounter("browser_perf_data_analysis_error_count", "The error number of browser performance data analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
        this.errorLogHistogram = metricsCreator.createHistogramMetric("browser_error_log_in_latency", "The process latency of browser error log", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.logErrorCounter = metricsCreator.createCounter("browser_error_log_analysis_error_count", "The error number of browser error log analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectPerfData(BrowserPerfData request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive browser performance data");
        }
        HistogramMetrics.Timer timer = this.perfHistogram.createTimer();
        try {
            PerfDataAnalyzer analyzer = new PerfDataAnalyzer(this.perfDataListenerManager);
            analyzer.doAnalysis(new BrowserPerfDataDecorator(request));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            this.perfErrorCounter.inc();
        }
        finally {
            timer.finish();
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectResourcePerfData(BrowserResourcePerfData request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive browser resource performance data");
        }
        HistogramMetrics.Timer timer = this.perfHistogram.createTimer();
        try {
            PerfDataAnalyzer analyzer = new PerfDataAnalyzer(this.perfDataListenerManager);
            analyzer.doAnalysis(new BrowserResourcePerfDataDecorator(request));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            this.perfErrorCounter.inc();
        }
        finally {
            timer.finish();
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectWebVitalsPerfData(BrowserWebVitalsPerfData request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive browser web vitals performance data");
        }
        HistogramMetrics.Timer timer = this.perfHistogram.createTimer();
        try {
            PerfDataAnalyzer analyzer = new PerfDataAnalyzer(this.perfDataListenerManager);
            analyzer.doAnalysis(new BrowserWebVitalsPerfDataDecorator(request));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            this.perfErrorCounter.inc();
        }
        finally {
            timer.finish();
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectWebInteractionsPerfData(BrowserWebInteractionsPerfData request, StreamObserver<Commands> responseObserver) {
        if (log.isDebugEnabled()) {
            log.debug("receive browser web interaction performance data");
        }
        HistogramMetrics.Timer timer = this.perfHistogram.createTimer();
        try {
            PerfDataAnalyzer analyzer = new PerfDataAnalyzer(this.perfDataListenerManager);
            analyzer.doAnalysis(new BrowserWebInteractionPerfDataDecorator(request));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            this.perfErrorCounter.inc();
        }
        finally {
            timer.finish();
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
        }
    }

    public StreamObserver<BrowserErrorLog> collectErrorLogs(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<BrowserErrorLog>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(BrowserErrorLog browserErrorLog) {
                if (log.isDebugEnabled()) {
                    log.debug("receive browser error log");
                }
                HistogramMetrics.Timer timer = BrowserPerfServiceHandler.this.errorLogHistogram.createTimer();
                try {
                    ErrorLogAnalyzer analyzer = new ErrorLogAnalyzer(BrowserPerfServiceHandler.this.moduleManager, BrowserPerfServiceHandler.this.errorLogListenerManager, BrowserPerfServiceHandler.this.config);
                    analyzer.doAnalysis(browserErrorLog);
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                    BrowserPerfServiceHandler.this.logErrorCounter.inc();
                }
                finally {
                    timer.finish();
                }
            }

            public void onError(Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

