/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.List;

@Internal
public class UniqueVariableNames
extends AbstractRule {
    public UniqueVariableNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        if (variableDefinitions == null || variableDefinitions.size() <= 1) {
            return;
        }
        LinkedHashSet<String> variableNameList = new LinkedHashSet<String>(variableDefinitions.size());
        for (VariableDefinition variableDefinition : variableDefinitions) {
            if (variableNameList.contains(variableDefinition.getName())) {
                String message = this.i18n(ValidationErrorType.DuplicateVariableName, "UniqueVariableNames.oneVariable", variableDefinition.getName());
                this.addError(ValidationErrorType.DuplicateVariableName, variableDefinition.getSourceLocation(), message);
                continue;
            }
            variableNameList.add(variableDefinition.getName());
        }
    }
}

