/*
 * Decompiled with CFR 0.152.
 */
package graphql.i18n;

import graphql.i18n.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class I18nMsg {
    private final String msgKey;
    private final List<Object> msgArguments;

    public I18nMsg(String msgKey, List<Object> msgArguments) {
        this.msgKey = msgKey;
        this.msgArguments = msgArguments;
    }

    public I18nMsg(String msgKey, Object ... msgArguments) {
        this.msgKey = msgKey;
        this.msgArguments = Arrays.asList(msgArguments);
    }

    public String getMsgKey() {
        return this.msgKey;
    }

    public Object[] getMsgArguments() {
        return this.msgArguments.toArray();
    }

    public I18nMsg addArgumentAt(int index, Object argument) {
        ArrayList<Object> newArgs = new ArrayList<Object>(this.msgArguments);
        newArgs.add(index, argument);
        return new I18nMsg(this.msgKey, newArgs);
    }

    public String toI18n(I18n i18n) {
        return i18n.msg(this.msgKey, this.msgArguments);
    }
}

