/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCBrowserLogQueryDAO
implements IBrowserLogQueryDAO {
    protected final JDBCClient jdbcClient;
    protected final TableHelper tableHelper;

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, BrowserErrorCategory category, Duration duration, int limit, int from) {
        ArrayList logs = new ArrayList();
        List<String> tables = this.tableHelper.getTablesForRead("browser_error_log", duration.getStartTimeBucket(), duration.getEndTimeBucket());
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(serviceId, serviceVersionId, pagePathId, category, duration, limit, from, table);
            this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                while (resultSet.next()) {
                    String dataBinaryBase64 = resultSet.getString("data_binary");
                    if (!Objects.nonNull(dataBinaryBase64)) continue;
                    BrowserErrorLog log = this.parserDataBinary(dataBinaryBase64);
                    logs.add(log);
                }
                return null;
            }, sqlAndParameters.parameters());
        }
        return new BrowserErrorLogs(logs.stream().sorted(Comparator.comparing(BrowserErrorLog::getTime).reversed()).skip(from).limit(limit).collect(Collectors.toList()));
    }

    protected SQLAndParameters buildSQL(String serviceId, String serviceVersionId, String pagePathId, BrowserErrorCategory category, Duration duration, int limit, int from, String table) {
        StringBuilder sql = new StringBuilder("select data_binary");
        ArrayList<Object> parameters = new ArrayList<Object>(9);
        sql.append(" from ").append(table).append(" where ").append("table_name").append(" = ? ");
        parameters.add("browser_error_log");
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        if (startSecondTB != 0L && endSecondTB != 0L) {
            sql.append(" and ").append("time_bucket").append(" >= ?");
            parameters.add(startSecondTB);
            sql.append(" and ").append("time_bucket").append(" <= ?");
            parameters.add(endSecondTB);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            sql.append(" and ").append("service_id").append(" = ?");
            parameters.add(serviceId);
        }
        if (StringUtil.isNotEmpty((String)serviceVersionId)) {
            sql.append(" and ").append("service_version_id").append(" = ?");
            parameters.add(serviceVersionId);
        }
        if (StringUtil.isNotEmpty((String)pagePathId)) {
            sql.append(" and ").append("page_path_id").append(" = ?");
            parameters.add(pagePathId);
        }
        if (Objects.nonNull(category)) {
            sql.append(" and ").append("error_category").append(" = ?");
            parameters.add(category.getValue());
        }
        sql.append(" order by ").append("timestamp").append(" DESC ");
        sql.append(" limit ").append(from + limit);
        return new SQLAndParameters(sql.toString(), parameters);
    }

    @Generated
    public JDBCBrowserLogQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

