/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.feishu;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.feishu.FeishuSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeishuHookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeishuHookCallback.class);
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, FeishuSettings> settingsMap = this.alarmRulesWatcher.getFeishuSettings();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            FeishuSettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getWebhooks()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (FeishuSettings.WebHookUrl webHookUrl : setting.getWebhooks()) {
                for (AlarmMessage alarmMessage : messages) {
                    String requestBody = this.getRequestBody(webHookUrl, alarmMessage, setting.getTextTemplate());
                    try {
                        this.post(URI.create(webHookUrl.getUrl()), requestBody, Map.of());
                    }
                    catch (Exception e) {
                        log.error("Failed to send alarm message to Feishu: {}", (Object)webHookUrl.getUrl(), (Object)e);
                    }
                }
            }
        }
    }

    private String getRequestBody(FeishuSettings.WebHookUrl webHookUrl, AlarmMessage alarmMessage, String textTemplate) {
        String requestBody = String.format(textTemplate, alarmMessage.getAlarmMessage());
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(requestBody, JsonObject.class);
        Map<String, Object> content = this.buildContent(jsonObject);
        if (!StringUtil.isBlank((String)webHookUrl.getSecret())) {
            long timestamp = System.currentTimeMillis() / 1000L;
            content.put("timestamp", timestamp);
            try {
                content.put("sign", this.sign(timestamp, webHookUrl.getSecret()));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return gson.toJson(content);
    }

    private Map<String, Object> buildContent(JsonObject jsonObject) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("msg_type", jsonObject.get("msg_type").getAsString());
        if (jsonObject.get("ats") != null) {
            String ats = jsonObject.get("ats").getAsString();
            List collect = Arrays.stream(ats.split(",")).map(String::trim).collect(Collectors.toList());
            Object text = jsonObject.get("content").getAsJsonObject().get("text").getAsString();
            for (String userId : collect) {
                text = (String)text + "<at user_id=\"" + userId + "\"></at>";
            }
            jsonObject.get("content").getAsJsonObject().addProperty("text", (String)text);
        }
        content.put("content", jsonObject.get("content").getAsJsonObject());
        return content;
    }

    private String sign(Long timestamp, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(stringToSign.getBytes(), "HmacSHA256"));
        byte[] signData = mac.doFinal();
        return Base64.getEncoder().encodeToString(signData);
    }

    @Generated
    public FeishuHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

