/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.imageio.ImageWriter;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.storage.base.WritableGridCoverageSupport;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.image.WorldFileResource;
import org.apache.sis.storage.image.WritableStore;

final class WritableResource
extends WorldFileResource
implements WritableGridCoverageResource {
    WritableResource(WritableStore store, StoreListeners parent, int imageIndex, GridGeometry gridGeometry) throws DataStoreException {
        super(store, parent, imageIndex, gridGeometry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(GridCoverage coverage, WritableGridCoverageResource.Option ... options) throws DataStoreException {
        WritableGridCoverageSupport h = new WritableGridCoverageSupport(this, options);
        WritableStore store = (WritableStore)this.store();
        try {
            WritableStore writableStore = store;
            synchronized (writableStore) {
                if (this.getImageIndex() != 0 || store.isMultiImages() != 0 && !h.replace(null)) {
                    coverage = h.update(coverage);
                }
                RenderedImage data = coverage.render(null);
                store.setGridGeometry(this.getImageIndex(), coverage.getGridGeometry());
                this.setGridCoverage(coverage);
                ImageWriter writer = store.writer();
                writer.write(data);
            }
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            throw new DataStoreException(store.resources().getString((short)69, store.getDisplayName()), e);
        }
    }
}

