/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;

public class LineAppender
extends Appender
implements Flushable {
    private String lineSeparator;
    private int maximalLineLength;
    private int codePointCount;
    private short tabulationWidth = (short)8;
    private boolean isTabulationExpanded;
    private boolean isEndOfLineReplaced;
    private boolean skipLF;
    private boolean isNewLine = true;
    private boolean isEscapeSequence;
    private final StringBuilder buffer = new StringBuilder();
    private int printableLength;

    public LineAppender(Appendable out) {
        super(out);
        this.maximalLineLength = Integer.MAX_VALUE;
    }

    public LineAppender(Appendable out, String lineSeparator, boolean isTabulationExpanded) {
        super(out);
        this.maximalLineLength = Integer.MAX_VALUE;
        this.lineSeparator = lineSeparator;
        this.isEndOfLineReplaced = lineSeparator != null;
        this.isTabulationExpanded = isTabulationExpanded;
    }

    public LineAppender(Appendable out, int maximalLineLength, boolean isTabulationExpanded) {
        super(out);
        ArgumentChecks.ensureStrictlyPositive("maximalLineLength", maximalLineLength);
        this.maximalLineLength = maximalLineLength;
        this.isTabulationExpanded = isTabulationExpanded;
    }

    public int getMaximalLineLength() {
        return this.maximalLineLength;
    }

    public void setMaximalLineLength(int length) {
        ArgumentChecks.ensureStrictlyPositive("length", length);
        this.maximalLineLength = length;
    }

    public int getCurrentLineLength() {
        return this.codePointCount;
    }

    public void setCurrentLineLength(int length) {
        ArgumentChecks.ensurePositive("length", length);
        this.codePointCount = length;
    }

    public int getTabulationWidth() {
        return this.tabulationWidth;
    }

    public void setTabulationWidth(int width) {
        ArgumentChecks.ensureStrictlyPositive("width", width);
        ArgumentChecks.ensureBetween("width", 1, Integer.MAX_VALUE, width);
        this.tabulationWidth = (short)width;
    }

    public boolean isTabulationExpanded() {
        return this.isTabulationExpanded;
    }

    public void setTabulationExpanded(boolean expanded) {
        this.isTabulationExpanded = expanded;
    }

    public String getLineSeparator() {
        return this.isEndOfLineReplaced ? this.lineSeparator : null;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.isEndOfLineReplaced = lineSeparator != null;
    }

    private void writeLineSeparator() throws IOException {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.lineSeparator();
        }
        this.out.append(this.lineSeparator);
    }

    private void endOfLine() throws IOException {
        this.buffer.setLength(this.printableLength);
        this.deleteSoftHyphen(this.printableLength - 1);
        this.transfer(this.printableLength);
        this.printableLength = 0;
        this.codePointCount = 0;
        this.isEscapeSequence = false;
        this.isNewLine = true;
    }

    private void deleteSoftHyphen(int i) {
        while (--i >= 0) {
            if (this.buffer.charAt(i) != '\u00ad') continue;
            this.buffer.deleteCharAt(i);
            --this.printableLength;
        }
    }

    private void transfer(int length) throws IOException {
        if (this.isNewLine) {
            this.isNewLine = false;
            this.onLineBegin(false);
        }
        this.out.append(this.buffer, 0, length);
        this.buffer.delete(0, length);
    }

    private void write(int c) throws IOException {
        int splitAt;
        if (Characters.isLineOrParagraphSeparator(c)) {
            boolean skip;
            switch (c) {
                case 13: {
                    skip = false;
                    this.skipLF = true;
                    break;
                }
                case 10: {
                    skip = this.skipLF;
                    this.skipLF = false;
                    break;
                }
                default: {
                    skip = false;
                    this.skipLF = false;
                }
            }
            if (!skip) {
                this.endOfLine();
            }
            if (!this.isEndOfLineReplaced) {
                this.appendCodePoint(c);
            } else if (!skip) {
                this.writeLineSeparator();
            }
            return;
        }
        this.skipLF = false;
        if (Character.isWhitespace(c)) {
            if (this.printableLength != 0) {
                this.deleteSoftHyphen(this.printableLength);
                this.transfer(this.printableLength);
                this.printableLength = 0;
            }
            if (c != 9) {
                ++this.codePointCount;
            } else {
                int width = this.tabulationWidth - this.codePointCount % this.tabulationWidth;
                this.codePointCount += width;
                if (this.isTabulationExpanded) {
                    this.buffer.append(CharSequences.spaces(width));
                    return;
                }
            }
            this.buffer.appendCodePoint(c);
            return;
        }
        this.buffer.appendCodePoint(c);
        this.printableLength = this.buffer.length();
        if (c == 27) {
            this.isEscapeSequence = true;
            return;
        }
        if (this.isEscapeSequence) {
            char previous = this.buffer.charAt(this.printableLength - 2);
            if (previous != '\u001b') {
                this.isEscapeSequence = c >= 48 && c <= 57;
                return;
            }
            if (c == 91) {
                return;
            }
            this.isEscapeSequence = false;
        }
        if (++this.codePointCount < this.maximalLineLength) {
            return;
        }
        int fallback = splitAt = this.buffer.length();
        boolean hasFallback = false;
        block10: while (true) {
            if (splitAt <= 0) {
                splitAt = fallback;
                break;
            }
            int b = this.buffer.codePointBefore(splitAt);
            int n = Character.charCount(b);
            switch (Character.getType(b)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 21: 
                case 29: {
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    int end = splitAt;
                    while (Character.isWhitespace(b) && (splitAt -= n) > 0) {
                        b = this.buffer.codePointBefore(splitAt);
                        n = Character.charCount(b);
                    }
                    if (splitAt == end) break;
                    this.buffer.delete(splitAt, end);
                    break block10;
                }
                case 20: {
                    if (b != 45 || (b = splitAt - n) <= 0 || Character.isLetter(this.buffer.codePointBefore(b))) break block10;
                    break;
                }
                case 16: {
                    if (b != 173) break;
                    this.buffer.setCharAt(splitAt - n, '\u2010');
                    break block10;
                }
                default: {
                    if (hasFallback || b == 60) break;
                    hasFallback = true;
                    fallback = splitAt;
                }
            }
            splitAt -= n;
        }
        this.transfer(splitAt);
        this.writeLineSeparator();
        this.printableLength = this.buffer.length();
        this.codePointCount = this.buffer.codePointCount(0, this.printableLength);
        this.onLineBegin(true);
    }

    @Override
    public Appendable append(char c) throws IOException {
        int cp = this.toCodePoint(c);
        if (cp >= 0) {
            this.write(cp);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence sequence, int start, int end) throws IOException {
        Objects.checkFromToIndex(start, end, sequence.length());
        if (this.lineSeparator == null) {
            this.lineSeparator = this.lineSeparator(sequence, start, end);
        }
        start = this.appendSurrogate(sequence, start, end);
        while (start < end) {
            int c;
            if ((c = this.toCodePoint(sequence.charAt(start++))) < 0) continue;
            this.write(c);
        }
        return this;
    }

    public void clear() throws IOException {
        this.endOfLine();
        this.skipLF = false;
    }

    @Override
    public void flush() throws IOException {
        this.out.append(this.buffer);
        this.buffer.setLength(0);
        this.printableLength = 0;
        IO.flush(this.out);
    }

    protected void onLineBegin(boolean isContinuation) throws IOException {
    }
}

