/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.controls;

import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.sis.gui.controls.TabularWidget;
import org.apache.sis.gui.dataset.WindowHandler;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.map.GestureFollower;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Vocabulary;

public final class SyncWindowList
extends TabularWidget
implements ListChangeListener<WindowHandler> {
    private final TableView<Link> table;
    private final Button newWindow;
    private final WindowHandler owner;
    private MapCanvas source;
    private final VBox content;

    public SyncWindowList(WindowHandler owner, Resources resources, Vocabulary vocabulary) {
        this.owner = owner;
        this.table = SyncWindowList.newTable();
        this.newWindow = new Button(resources.getString((short)26));
        this.newWindow.setMaxWidth(Double.MAX_VALUE);
        this.table.getColumns().setAll((Object[])new TableColumn[]{SyncWindowList.newBooleanColumn("\ud83d\udd17", cell -> ((Link)((Object)((Object)cell.getValue()))).transformEnabled), SyncWindowList.newStringColumn(vocabulary.getString((short)270), cell -> ((Link)((Object)((Object)cell.getValue()))).view.title)});
        this.table.setRowFactory(SyncWindowList::newRow);
        this.newWindow.setOnAction(e -> owner.duplicate().show());
        VBox.setVgrow(this.table, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.newWindow, (Priority)Priority.NEVER);
        this.content = new VBox(9.0, new Node[]{this.table, this.newWindow});
        Platform.runLater(() -> this.addAll((List<? extends WindowHandler>)owner.manager.windows));
        owner.manager.windows.addListener((ListChangeListener)this);
    }

    private static TableRow<Link> newRow(TableView<Link> table) {
        TableRow row = new TableRow();
        row.addEventFilter(MouseEvent.MOUSE_CLICKED, SyncWindowList::onMouseClicked);
        return row;
    }

    private static void onMouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            TableRow row = (TableRow)event.getSource();
            Link item = (Link)((Object)row.getItem());
            item.view.show();
            event.consume();
            row.getTableView().edit(-1, null);
        }
    }

    @Override
    public Region getView() {
        return this.content;
    }

    public void onChanged(ListChangeListener.Change<? extends WindowHandler> change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                ObservableList items = this.table.getItems();
                block1: for (WindowHandler view : change.getRemoved()) {
                    int i = items.size();
                    while (--i >= 0) {
                        Link item = (Link)((Object)items.get(i));
                        if (item.view != view) continue;
                        items.remove(i);
                        item.dispose();
                        continue block1;
                    }
                }
            }
            if (!change.wasAdded()) continue;
            this.addAll(change.getAddedSubList());
        }
    }

    private void addAll(List<? extends WindowHandler> windows) {
        if (this.source == null) {
            this.source = this.owner.getCanvas().get();
        }
        Link.wrap(windows, (List<Link>)this.table.getItems(), this.owner, this.source);
    }

    private static final class Link
    extends GestureFollower {
        public final WindowHandler view;

        private Link(WindowHandler view, MapCanvas source, MapCanvas target) {
            super(source, target);
            this.view = view;
        }

        static void wrap(List<? extends WindowHandler> added, List<Link> addTo, WindowHandler owner, MapCanvas source) {
            Link[] items = new Link[added.size()];
            int count = 0;
            try {
                for (WindowHandler windowHandler : added) {
                    MapCanvas target;
                    if (windowHandler == owner || (target = (MapCanvas)windowHandler.getCanvas().orElse(null)) == null) continue;
                    Link item = new Link(windowHandler, source, target);
                    items[count++] = item;
                    item.initialize();
                    item.cursorEnabled.set(true);
                }
                addTo.addAll((Collection<Link>)UnmodifiableArrayList.wrap((Object[])items, (int)0, (int)count));
            }
            catch (Throwable e) {
                while (--count >= 0) {
                    items[--count].dispose();
                }
                throw e;
            }
        }
    }
}

