/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.ai.proxy;

import java.util.List;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.factory.DeepSeekModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.factory.OpenAiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.registry.AiModelFactoryRegistry;
import org.apache.shenyu.plugin.ai.proxy.enhanced.AiProxyPlugin;
import org.apache.shenyu.plugin.ai.proxy.enhanced.cache.ChatClientCache;
import org.apache.shenyu.plugin.ai.proxy.enhanced.handler.AiProxyPluginHandler;
import org.apache.shenyu.plugin.ai.proxy.enhanced.service.AiProxyConfigService;
import org.apache.shenyu.plugin.ai.proxy.enhanced.service.AiProxyExecutorService;
import org.apache.shenyu.plugin.ai.proxy.enhanced.subscriber.CommonAiProxyApiKeyDataSubscriber;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.sync.data.api.AiProxyApiKeyDataSubscriber;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.ai.proxy.enabled"}, havingValue="true", matchIfMissing=true)
public class AiProxyPluginConfiguration {
    @Bean
    public ShenyuPlugin aiProxyPlugin(AiModelFactoryRegistry aiModelFactoryRegistry, AiProxyConfigService aiProxyConfigService, AiProxyExecutorService aiProxyExecutorService, ChatClientCache chatClientCache, AiProxyPluginHandler aiProxyPluginHandler) {
        return new AiProxyPlugin(aiModelFactoryRegistry, aiProxyConfigService, aiProxyExecutorService, chatClientCache, aiProxyPluginHandler);
    }

    @Bean
    public AiProxyPluginHandler aiProxyPluginHandler(ChatClientCache chatClientCache) {
        return new AiProxyPluginHandler(chatClientCache);
    }

    @Bean
    public ChatClientCache chatClientCache() {
        return new ChatClientCache();
    }

    @Bean
    public AiProxyConfigService aiProxyConfigService() {
        return new AiProxyConfigService();
    }

    @Bean
    public AiProxyExecutorService aiProxyExecutorService() {
        return new AiProxyExecutorService();
    }

    @Bean
    public AiModelFactoryRegistry aiModelFactoryRegistry(List<AiModelFactory> aiModelFactoryList) {
        return new AiModelFactoryRegistry(aiModelFactoryList);
    }

    @Bean
    public OpenAiModelFactory openAiModelFactory() {
        return new OpenAiModelFactory();
    }

    @Bean
    public DeepSeekModelFactory deepSeekModelFactory() {
        return new DeepSeekModelFactory();
    }

    @Bean
    public AiProxyApiKeyDataSubscriber aiProxyApiKeyDataSubscriber(ChatClientCache chatClientCache) {
        return new CommonAiProxyApiKeyDataSubscriber(chatClientCache);
    }
}

