/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.local;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.FileUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;

public class LocalRegistryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRegistryHelper.class);
    private static String SEPARATORSTR = "\t";

    public static boolean checkModified(String address, String lastDigest) {
        String newDigest = LocalRegistryHelper.calMD5Checksum(address);
        return !StringUtils.equals(newDigest, lastDigest);
    }

    public static ProviderInfo convertProviderToProviderInfo(ProviderConfig config, ServerConfig server) {
        ProviderInfo providerInfo = new ProviderInfo().setPort(server.getPort()).setWeight(config.getWeight()).setSerializationType(config.getSerialization()).setProtocolType(server.getProtocol()).setPath(server.getContextPath()).setStaticAttrs(config.getParameters());
        String host = server.getHost();
        if (NetUtils.isLocalHost(host) || NetUtils.isAnyHost(host)) {
            host = SystemInfo.getLocalHost();
        }
        providerInfo.setHost(host);
        return providerInfo;
    }

    static Map<String, ProviderGroup> loadBackupFileToCache(String address) {
        ConcurrentHashMap<String, ProviderGroup> memoryCache = new ConcurrentHashMap<String, ProviderGroup>();
        File regFile = new File(address);
        if (!regFile.exists()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Load backup file failure cause by can't found file: {}", regFile.getAbsolutePath());
            }
        } else {
            try {
                String content = FileUtils.file2String(regFile);
                Map<String, ProviderGroup> tmp = LocalRegistryHelper.unMarshal(content);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Load backup file from {}", regFile.getAbsolutePath());
                }
                if (tmp != null) {
                    memoryCache.putAll(tmp);
                }
            }
            catch (IOException e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010060023", regFile.getAbsolutePath()), e);
            }
        }
        return memoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean backup(String address, Map<String, ProviderGroup> memoryCache) {
        block20: {
            File lockFile = new File(address + ".lock");
            while (lockFile.exists()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Other process is writing, retry after 1s");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!lockFile.exists()) continue;
                if (RpcRuntimeContext.now() - lockFile.lastModified() > 10000L) {
                    boolean ret = lockFile.delete();
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Other process is locking over 60s, force release : {}", ret);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Other process is stilling writing, waiting 1s ...");
            }
            boolean created = false;
            try {
                lockFile.getParentFile().mkdirs();
                created = lockFile.createNewFile();
                if (!created) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Create lock file false, may be other process is writing. aborted");
                    }
                    boolean bl = false;
                    return bl;
                }
                String content = StringUtils.defaultString(LocalRegistryHelper.marshalCache(memoryCache));
                File regFile = new File(address);
                if (regFile.exists() && !regFile.renameTo(new File(address + ".bak"))) {
                    regFile.delete();
                }
                if (!regFile.createNewFile()) break block20;
                RandomAccessFile randomAccessFile = null;
                FileLock lock = null;
                try {
                    randomAccessFile = new RandomAccessFile(regFile, "rw");
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    lock = fileChannel.tryLock();
                    fileChannel.write(RpcConstants.DEFAULT_CHARSET.encode(content));
                    fileChannel.force(false);
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                LOGGER.info("Write backup file to {}", regFile.getAbsolutePath());
                regFile.setLastModified(RpcRuntimeContext.now());
            }
            catch (Exception e) {
                LOGGER.error("Backup registry file error !", e);
            }
            finally {
                boolean deleted;
                if (created && !(deleted = lockFile.delete()) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Lock file create by this thread, but failed to delete it, may be the elapsed time of this backup is too long");
                }
            }
        }
        return true;
    }

    private static String marshalCache(Map<String, ProviderGroup> memoryCache) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ProviderGroup> entry : memoryCache.entrySet()) {
            List<ProviderInfo> ps;
            ProviderGroup group = entry.getValue();
            if (group == null || !CommonUtils.isNotEmpty(ps = group.getProviderInfos())) continue;
            sb.append(entry.getKey()).append(SEPARATORSTR);
            for (ProviderInfo providerInfo : ps) {
                sb.append(ProviderHelper.toUrl(providerInfo)).append(SEPARATORSTR);
            }
            sb.append(FileUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private static Map<String, ProviderGroup> unMarshal(String context) {
        String[] lines;
        if (StringUtils.isBlank(context)) {
            return null;
        }
        HashMap<String, ProviderGroup> map = new HashMap<String, ProviderGroup>();
        for (String line : lines = StringUtils.split(context, FileUtils.LINE_SEPARATOR)) {
            String[] fields = line.split(SEPARATORSTR);
            if (fields.length <= 1) continue;
            String key = fields[0];
            HashSet<ProviderInfo> values = new HashSet<ProviderInfo>();
            for (int i = 1; i < fields.length; ++i) {
                String pstr = fields[i];
                if (!StringUtils.isNotEmpty(pstr)) continue;
                ProviderInfo providerInfo = ProviderHelper.toProviderInfo(pstr);
                providerInfo.setStaticAttr("source", "local");
                values.add(providerInfo);
            }
            map.put(key, new ProviderGroup(new ArrayList<ProviderInfo>(values)));
        }
        return map;
    }

    static String buildListDataId(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(config) + "@DEFAULT";
        }
        return ConfigUniqueNameGenerator.getUniqueName(config) + "@" + protocol;
    }

    private static byte[] createChecksum(String filename) {
        MessageDigest complete = null;
        try {
            complete = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String content = null;
        try {
            File file = new File(filename);
            content = FileUtils.file2String(file);
        }
        catch (IOException file) {
            // empty catch block
        }
        if (content == null) {
            content = "";
        }
        byte[] digest = new byte[]{};
        if (complete != null) {
            digest = complete.digest(content.getBytes());
        }
        return digest;
    }

    public static String calMD5Checksum(String filename) {
        byte[] b = LocalRegistryHelper.createChecksum(filename);
        String digestInHex = DatatypeConverter.printHexBinary((byte[])b).toUpperCase();
        return digestInHex;
    }
}

