/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.protocol.telnet;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.protocol.TelnetHandler;
import com.alipay.sofa.rpc.protocol.TelnetHandlerFactory;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import java.util.Map;

@Extension(value="help")
public class HelpTelnetHandler
implements TelnetHandler {
    @Override
    public String getCommand() {
        return "help";
    }

    @Override
    public String telnet(AbstractChannel channel, String message) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotBlank(message)) {
            TelnetHandler handler = TelnetHandlerFactory.getHandler(message);
            if (handler != null) {
                result.append(handler.getCommand()).append("\r\n").append(handler.getDescription()).append("\r\n");
            } else {
                result.append("Not found command : " + message);
            }
        } else {
            result.append("The supported command include:").append("\r\n");
            for (Map.Entry<String, TelnetHandler> entry : TelnetHandlerFactory.getAllHandlers().entrySet()) {
                result.append(entry.getKey()).append(" ");
            }
            result.append("\r\n");
        }
        return result.toString();
    }

    @Override
    public String getDescription() {
        return "show all support commands!\r\nUsage:\thelp\r\n\thelp [cmd]";
    }
}

