/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message;

import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.message.ResponseFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractResponseFuture<V>
implements ResponseFuture<V> {
    protected static final CancellationException CANCELLATION_CAUSE = new CancellationException();
    protected volatile Object result;
    protected volatile Throwable cause;
    protected final int timeout;
    protected final long genTime = RpcRuntimeContext.now();
    protected volatile long sentTime;
    protected volatile long doneTime;
    private short waiters;

    public AbstractResponseFuture(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long realTimeOut = unit.toMillis(timeout);
        long remainTime = realTimeOut - (this.sentTime - this.genTime);
        if (remainTime <= 0L ? this.isDone() : this.await(remainTime, TimeUnit.MILLISECONDS)) {
            return this.getNow();
        }
        this.setDoneTime();
        throw this.clientTimeoutException();
    }

    protected TimeoutException clientTimeoutException() {
        return new TimeoutException();
    }

    protected abstract V getNow() throws ExecutionException;

    protected abstract void releaseIfNeed(Object var1);

    protected boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    /*
     * Exception decompiling
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasWaiters() {
        return this.waiters > 0;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean res = this.cancle0(mayInterruptIfRunning);
        this.notifyListeners();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancle0(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        AbstractResponseFuture abstractResponseFuture = this;
        synchronized (abstractResponseFuture) {
            if (this.isDone()) {
                return false;
            }
            this.cause = CANCELLATION_CAUSE;
            this.setDoneTime();
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    public void setSuccess(V result) {
        if (this.isCancelled()) {
            this.releaseIfNeed(result);
        }
        if (this.setSuccess0(result)) {
            this.notifyListeners();
            return;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSuccess0(V result) {
        if (this.isDone()) {
            return false;
        }
        AbstractResponseFuture abstractResponseFuture = this;
        synchronized (abstractResponseFuture) {
            if (this.isDone()) {
                return false;
            }
            if (this.result == null) {
                this.result = result;
            }
            this.setDoneTime();
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    public void setFailure(Throwable cause) {
        if (this.isCancelled()) {
            this.releaseIfNeed(this.result);
            return;
        }
        if (this.setFailure0(cause)) {
            this.notifyListeners();
            return;
        }
        throw new IllegalStateException("complete already: " + this, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFailure0(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        AbstractResponseFuture abstractResponseFuture = this;
        synchronized (abstractResponseFuture) {
            if (this.isDone()) {
                return false;
            }
            this.cause = cause;
            this.setDoneTime();
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cause == CANCELLATION_CAUSE;
    }

    @Override
    public boolean isDone() {
        return this.result != null || this.cause != null;
    }

    public abstract void notifyListeners();

    public void setSentTime() {
        this.sentTime = RpcRuntimeContext.now();
    }

    protected void setDoneTime() {
        if (this.doneTime == 0L) {
            this.doneTime = RpcRuntimeContext.now();
        }
    }

    public long getElapsedTime() {
        return this.doneTime - this.genTime;
    }
}

