/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.bzip2;

import com.alipay.sofa.rpc.codec.Compressor;
import com.alipay.sofa.rpc.ext.Extension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

@Extension(value="bzip2", code=3)
public class Bzip2RpcCompressor
implements Compressor {
    @Override
    public byte[] compress(byte[] src) {
        if (null == src || 0 == src.length) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BZip2CompressorOutputStream cos = new BZip2CompressorOutputStream((OutputStream)out);
            cos.write(src);
            cos.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] deCompress(byte[] src) {
        if (null == src || 0 == src.length) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        try {
            int n;
            BZip2CompressorInputStream unZip = new BZip2CompressorInputStream((InputStream)in);
            byte[] buffer = new byte[2048];
            while ((n = unZip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return out.toByteArray();
    }
}

