/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.cache;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.AppAuthData;

public final class SignAuthDataCache {
    private static final SignAuthDataCache INSTANCE = new SignAuthDataCache();
    private static final ConcurrentMap<String, AppAuthData> AUTH_MAP = Maps.newConcurrentMap();

    private SignAuthDataCache() {
    }

    public static SignAuthDataCache getInstance() {
        return INSTANCE;
    }

    public void cacheAuthData(AppAuthData data) {
        AUTH_MAP.put(data.getAppKey(), data);
    }

    public void removeAuthData(AppAuthData data) {
        AUTH_MAP.remove(data.getAppKey());
    }

    public AppAuthData obtainAuthData(String appKey) {
        return (AppAuthData)AUTH_MAP.get(appKey);
    }
}

