/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.FluxSentinelOperator;
import com.alibaba.csp.sentinel.adapter.reactor.MonoSentinelOperator;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SentinelReactorTransformer<T>
implements Function<Publisher<T>, Publisher<T>> {
    private final EntryConfig entryConfig;

    public SentinelReactorTransformer(String resourceName) {
        this(new EntryConfig(resourceName));
    }

    public SentinelReactorTransformer(EntryConfig entryConfig) {
        AssertUtil.notNull((Object)entryConfig, (String)"entryConfig cannot be null");
        this.entryConfig = entryConfig;
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoSentinelOperator((Mono)publisher, this.entryConfig);
        }
        if (publisher instanceof Flux) {
            return new FluxSentinelOperator((Flux)publisher, this.entryConfig);
        }
        throw new IllegalStateException("Publisher type is not supported: " + publisher.getClass().getCanonicalName());
    }
}

