/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.opentracing.BraveScopeManager;
import brave.opentracing.BraveSpan;
import io.opentracing.Scope;

public final class BraveScope
implements Scope {
    private final BraveScopeManager source;
    private final Tracer.SpanInScope scope;
    private final BraveSpan wrapped;
    private final boolean finishSpanOnClose;

    BraveScope(BraveScopeManager source, Tracer.SpanInScope scope, BraveSpan wrapped, boolean finishSpanOnClose) {
        this.source = source;
        this.scope = scope;
        this.wrapped = wrapped;
        this.finishSpanOnClose = finishSpanOnClose;
    }

    public void close() {
        if (this.finishSpanOnClose) {
            this.wrapped.finish();
        }
        this.scope.close();
        this.source.deregister(this);
    }

    public BraveSpan span() {
        return this.wrapped;
    }

    public String toString() {
        return "BraveScope{scope=" + this.scope + ", wrapped=" + this.wrapped + '}';
    }
}

