/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.injvm;

import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.injvm.InjvmExporter;
import org.apache.dubbo.rpc.protocol.injvm.InjvmInvoker;

public class InjvmProtocol
extends AbstractProtocol {
    public static final String NAME = "injvm";
    public static final int DEFAULT_PORT = 0;

    public static InjvmProtocol getInjvmProtocol(ScopeModel scopeModel) {
        return (InjvmProtocol)scopeModel.getExtensionLoader(Protocol.class).getExtension(NAME, false);
    }

    static Exporter<?> getExporter(Map<String, Exporter<?>> map, URL key) {
        Exporter<?> result = null;
        if (!key.getServiceKey().contains("*")) {
            result = map.get(key.getServiceKey());
        } else if (CollectionUtils.isNotEmptyMap(map)) {
            for (Exporter<?> exporter : map.values()) {
                if (!UrlUtils.isServiceKeyMatch(key, exporter.getInvoker().getUrl())) continue;
                result = exporter;
                break;
            }
        }
        return result;
    }

    @Override
    public int getDefaultPort() {
        return 0;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        return new InjvmExporter<T>(invoker, invoker.getUrl().getServiceKey(), this.exporterMap);
    }

    @Override
    public <T> Invoker<T> protocolBindingRefer(Class<T> serviceType, URL url) throws RpcException {
        return new InjvmInvoker<T>(serviceType, url, url.getServiceKey(), this.exporterMap);
    }

    public boolean isInjvmRefer(URL url) {
        String scope = url.getParameter("scope");
        if ("local".equals(scope) || url.getParameter(NAME, false)) {
            return true;
        }
        if ("remote".equals(scope)) {
            return false;
        }
        if (url.getParameter("generic", false)) {
            return false;
        }
        if (InjvmProtocol.getExporter(this.exporterMap, url) != null) {
            return !"broadcast".equalsIgnoreCase(url.getParameter("cluster"));
        }
        return false;
    }
}

