/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;

public class SpringCloudMetadataServiceURLBuilder
implements MetadataServiceURLBuilder {
    public static final String NAME = "spring-cloud";

    @Override
    public List<URL> build(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String dubboUrlsForJson = metadata.get("dubbo.metadata-service.urls");
        if (StringUtils.isBlank(dubboUrlsForJson)) {
            return Collections.emptyList();
        }
        List<String> urlStrings = JsonUtils.toJavaList(dubboUrlsForJson, String.class);
        return urlStrings.stream().map(URL::valueOf).collect(Collectors.toList());
    }
}

